// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restxml"
)

type PutBucketAnalyticsConfigurationInput struct {
	_ struct{} `type:"structure" payload:"AnalyticsConfiguration"`

	// The configuration and any analyses for the analytics filter.
	//
	// AnalyticsConfiguration is a required field
	AnalyticsConfiguration *AnalyticsConfiguration `locationName:"AnalyticsConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// The name of the bucket to which an analytics configuration is stored.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The ID that identifies the analytics configuration.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s PutBucketAnalyticsConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketAnalyticsConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBucketAnalyticsConfigurationInput"}

	if s.AnalyticsConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("AnalyticsConfiguration"))
	}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.AnalyticsConfiguration != nil {
		if err := s.AnalyticsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AnalyticsConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutBucketAnalyticsConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketAnalyticsConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.AnalyticsConfiguration != nil {
		v := s.AnalyticsConfiguration

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "AnalyticsConfiguration", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "id", protocol.StringValue(v), metadata)
	}
	return nil
}

type PutBucketAnalyticsConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketAnalyticsConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketAnalyticsConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opPutBucketAnalyticsConfiguration = "PutBucketAnalyticsConfiguration"

// PutBucketAnalyticsConfigurationRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Sets an analytics configuration for the bucket (specified by the analytics
// configuration ID). You can have up to 1,000 analytics configurations per
// bucket.
//
// You can choose to have storage class analysis export analysis reports sent
// to a comma-separated values (CSV) flat file. See the DataExport request element.
// Reports are updated daily and are based on the object filters that you configure.
// When selecting data export, you specify a destination bucket and an optional
// destination prefix where the file is written. You can export the data to
// a destination bucket in a different account. However, the destination bucket
// must be in the same Region as the bucket that you are making the PUT analytics
// configuration to. For more information, see Amazon S3 Analytics – Storage
// Class Analysis (https://docs.aws.amazon.com/AmazonS3/latest/dev/analytics-storage-class.html).
//
// You must create a bucket policy on the destination bucket where the exported
// file is written to grant permissions to Amazon S3 to write objects to the
// bucket. For an example policy, see Granting Permissions for Amazon S3 Inventory
// and Storage Class Analysis (https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html#example-bucket-policies-use-case-9).
//
// To use this operation, you must have permissions to perform the s3:PutAnalyticsConfiguration
// action. The bucket owner has this permission by default. The bucket owner
// can grant this permission to others. For more information about permissions,
// see Permissions Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html).
//
// Special Errors
//
//    * HTTP Error: HTTP 400 Bad Request Code: InvalidArgument Cause: Invalid
//    argument.
//
//    * HTTP Error: HTTP 400 Bad Request Code: TooManyConfigurations Cause:
//    You are attempting to create a new configuration but have already reached
//    the 1,000-configuration limit.
//
//    * HTTP Error: HTTP 403 Forbidden Code: AccessDenied Cause: You are not
//    the owner of the specified bucket, or you do not have the s3:PutAnalyticsConfiguration
//    bucket permission to set the configuration on the bucket.
//
// Related Resources
//
//    *
//
//    *
//
//    *
//
//    // Example sending a request using PutBucketAnalyticsConfigurationRequest.
//    req := client.PutBucketAnalyticsConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAnalyticsConfiguration
func (c *Client) PutBucketAnalyticsConfigurationRequest(input *PutBucketAnalyticsConfigurationInput) PutBucketAnalyticsConfigurationRequest {
	op := &aws.Operation{
		Name:       opPutBucketAnalyticsConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?analytics",
	}

	if input == nil {
		input = &PutBucketAnalyticsConfigurationInput{}
	}

	req := c.newRequest(op, input, &PutBucketAnalyticsConfigurationOutput{})
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return PutBucketAnalyticsConfigurationRequest{Request: req, Input: input, Copy: c.PutBucketAnalyticsConfigurationRequest}
}

// PutBucketAnalyticsConfigurationRequest is the request type for the
// PutBucketAnalyticsConfiguration API operation.
type PutBucketAnalyticsConfigurationRequest struct {
	*aws.Request
	Input *PutBucketAnalyticsConfigurationInput
	Copy  func(*PutBucketAnalyticsConfigurationInput) PutBucketAnalyticsConfigurationRequest
}

// Send marshals and sends the PutBucketAnalyticsConfiguration API request.
func (r PutBucketAnalyticsConfigurationRequest) Send(ctx context.Context) (*PutBucketAnalyticsConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutBucketAnalyticsConfigurationResponse{
		PutBucketAnalyticsConfigurationOutput: r.Request.Data.(*PutBucketAnalyticsConfigurationOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutBucketAnalyticsConfigurationResponse is the response type for the
// PutBucketAnalyticsConfiguration API operation.
type PutBucketAnalyticsConfigurationResponse struct {
	*PutBucketAnalyticsConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutBucketAnalyticsConfiguration request.
func (r *PutBucketAnalyticsConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
