// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// A request for information about whether a specified geographic location is
// supported for Amazon Route 53 geolocation resource record sets.
type GetGeoLocationInput struct {
	_ struct{} `type:"structure"`

	// Amazon Route 53 supports the following continent codes:
	//
	//    * AF: Africa
	//
	//    * AN: Antarctica
	//
	//    * AS: Asia
	//
	//    * EU: Europe
	//
	//    * OC: Oceania
	//
	//    * NA: North America
	//
	//    * SA: South America
	ContinentCode *string `location:"querystring" locationName:"continentcode" min:"2" type:"string"`

	// Amazon Route 53 uses the two-letter country codes that are specified in ISO
	// standard 3166-1 alpha-2 (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2).
	CountryCode *string `location:"querystring" locationName:"countrycode" min:"1" type:"string"`

	// Amazon Route 53 uses the one- to three-letter subdivision codes that are
	// specified in ISO standard 3166-1 alpha-2 (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2).
	// Route 53 doesn't support subdivision codes for all countries. If you specify
	// subdivisioncode, you must also specify countrycode.
	SubdivisionCode *string `location:"querystring" locationName:"subdivisioncode" min:"1" type:"string"`
}

// String returns the string representation
func (s GetGeoLocationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGeoLocationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetGeoLocationInput"}
	if s.ContinentCode != nil && len(*s.ContinentCode) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("ContinentCode", 2))
	}
	if s.CountryCode != nil && len(*s.CountryCode) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CountryCode", 1))
	}
	if s.SubdivisionCode != nil && len(*s.SubdivisionCode) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SubdivisionCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetGeoLocationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.ContinentCode != nil {
		v := *s.ContinentCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "continentcode", protocol.StringValue(v), metadata)
	}
	if s.CountryCode != nil {
		v := *s.CountryCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "countrycode", protocol.StringValue(v), metadata)
	}
	if s.SubdivisionCode != nil {
		v := *s.SubdivisionCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "subdivisioncode", protocol.StringValue(v), metadata)
	}
	return nil
}

// A complex type that contains the response information for the specified geolocation
// code.
type GetGeoLocationOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains the codes and full continent, country, and subdivision
	// names for the specified geolocation code.
	//
	// GeoLocationDetails is a required field
	GeoLocationDetails *GeoLocationDetails `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetGeoLocationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetGeoLocationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.GeoLocationDetails != nil {
		v := s.GeoLocationDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "GeoLocationDetails", v, metadata)
	}
	return nil
}

const opGetGeoLocation = "GetGeoLocation"

// GetGeoLocationRequest returns a request value for making API operation for
// Amazon Route 53.
//
// Gets information about whether a specified geographic location is supported
// for Amazon Route 53 geolocation resource record sets.
//
// Use the following syntax to determine whether a continent is supported for
// geolocation:
//
// GET /2013-04-01/geolocation?continentcode=two-letter abbreviation for a continent
//
// Use the following syntax to determine whether a country is supported for
// geolocation:
//
// GET /2013-04-01/geolocation?countrycode=two-character country code
//
// Use the following syntax to determine whether a subdivision of a country
// is supported for geolocation:
//
// GET /2013-04-01/geolocation?countrycode=two-character country code&subdivisioncode=subdivision
// code
//
//    // Example sending a request using GetGeoLocationRequest.
//    req := client.GetGeoLocationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetGeoLocation
func (c *Client) GetGeoLocationRequest(input *GetGeoLocationInput) GetGeoLocationRequest {
	op := &aws.Operation{
		Name:       opGetGeoLocation,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/geolocation",
	}

	if input == nil {
		input = &GetGeoLocationInput{}
	}

	req := c.newRequest(op, input, &GetGeoLocationOutput{})
	return GetGeoLocationRequest{Request: req, Input: input, Copy: c.GetGeoLocationRequest}
}

// GetGeoLocationRequest is the request type for the
// GetGeoLocation API operation.
type GetGeoLocationRequest struct {
	*aws.Request
	Input *GetGeoLocationInput
	Copy  func(*GetGeoLocationInput) GetGeoLocationRequest
}

// Send marshals and sends the GetGeoLocation API request.
func (r GetGeoLocationRequest) Send(ctx context.Context) (*GetGeoLocationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetGeoLocationResponse{
		GetGeoLocationOutput: r.Request.Data.(*GetGeoLocationOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetGeoLocationResponse is the response type for the
// GetGeoLocation API operation.
type GetGeoLocationResponse struct {
	*GetGeoLocationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetGeoLocation request.
func (r *GetGeoLocationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
