// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// The result of the DeleteSnapshotCopyGrant action.
type DeleteSnapshotCopyGrantInput struct {
	_ struct{} `type:"structure"`

	// The name of the snapshot copy grant to delete.
	//
	// SnapshotCopyGrantName is a required field
	SnapshotCopyGrantName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSnapshotCopyGrantInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSnapshotCopyGrantInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteSnapshotCopyGrantInput"}

	if s.SnapshotCopyGrantName == nil {
		invalidParams.Add(aws.NewErrParamRequired("SnapshotCopyGrantName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteSnapshotCopyGrantOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSnapshotCopyGrantOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteSnapshotCopyGrant = "DeleteSnapshotCopyGrant"

// DeleteSnapshotCopyGrantRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Deletes the specified snapshot copy grant.
//
//    // Example sending a request using DeleteSnapshotCopyGrantRequest.
//    req := client.DeleteSnapshotCopyGrantRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteSnapshotCopyGrant
func (c *Client) DeleteSnapshotCopyGrantRequest(input *DeleteSnapshotCopyGrantInput) DeleteSnapshotCopyGrantRequest {
	op := &aws.Operation{
		Name:       opDeleteSnapshotCopyGrant,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSnapshotCopyGrantInput{}
	}

	req := c.newRequest(op, input, &DeleteSnapshotCopyGrantOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteSnapshotCopyGrantRequest{Request: req, Input: input, Copy: c.DeleteSnapshotCopyGrantRequest}
}

// DeleteSnapshotCopyGrantRequest is the request type for the
// DeleteSnapshotCopyGrant API operation.
type DeleteSnapshotCopyGrantRequest struct {
	*aws.Request
	Input *DeleteSnapshotCopyGrantInput
	Copy  func(*DeleteSnapshotCopyGrantInput) DeleteSnapshotCopyGrantRequest
}

// Send marshals and sends the DeleteSnapshotCopyGrant API request.
func (r DeleteSnapshotCopyGrantRequest) Send(ctx context.Context) (*DeleteSnapshotCopyGrantResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteSnapshotCopyGrantResponse{
		DeleteSnapshotCopyGrantOutput: r.Request.Data.(*DeleteSnapshotCopyGrantOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteSnapshotCopyGrantResponse is the response type for the
// DeleteSnapshotCopyGrant API operation.
type DeleteSnapshotCopyGrantResponse struct {
	*DeleteSnapshotCopyGrantOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteSnapshotCopyGrant request.
func (r *DeleteSnapshotCopyGrantResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
