// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rdsdata

import (
	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Contains an array.
type ArrayValue struct {
	_ struct{} `type:"structure"`

	// An array of arrays.
	ArrayValues []ArrayValue `locationName:"arrayValues" type:"list"`

	// An array of Boolean values.
	BooleanValues []bool `locationName:"booleanValues" type:"list"`

	// An array of integers.
	DoubleValues []float64 `locationName:"doubleValues" type:"list"`

	// An array of floating point numbers.
	LongValues []int64 `locationName:"longValues" type:"list"`

	// An array of strings.
	StringValues []string `locationName:"stringValues" type:"list"`
}

// String returns the string representation
func (s ArrayValue) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ArrayValue) MarshalFields(e protocol.FieldEncoder) error {
	if s.ArrayValues != nil {
		v := s.ArrayValues

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "arrayValues", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.BooleanValues != nil {
		v := s.BooleanValues

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "booleanValues", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.BoolValue(v1))
		}
		ls0.End()

	}
	if s.DoubleValues != nil {
		v := s.DoubleValues

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "doubleValues", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.Float64Value(v1))
		}
		ls0.End()

	}
	if s.LongValues != nil {
		v := s.LongValues

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "longValues", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.Int64Value(v1))
		}
		ls0.End()

	}
	if s.StringValues != nil {
		v := s.StringValues

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "stringValues", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Contains the metadata for a column.
type ColumnMetadata struct {
	_ struct{} `type:"structure"`

	// The type of the column.
	ArrayBaseColumnType *int64 `locationName:"arrayBaseColumnType" type:"integer"`

	// A value that indicates whether the column increments automatically.
	IsAutoIncrement *bool `locationName:"isAutoIncrement" type:"boolean"`

	// A value that indicates whether the column is case-sensitive.
	IsCaseSensitive *bool `locationName:"isCaseSensitive" type:"boolean"`

	// A value that indicates whether the column contains currency values.
	IsCurrency *bool `locationName:"isCurrency" type:"boolean"`

	// A value that indicates whether an integer column is signed.
	IsSigned *bool `locationName:"isSigned" type:"boolean"`

	// The label for the column.
	Label *string `locationName:"label" type:"string"`

	// The name of the column.
	Name *string `locationName:"name" type:"string"`

	// A value that indicates whether the column is nullable.
	Nullable *int64 `locationName:"nullable" type:"integer"`

	// The precision value of a decimal number column.
	Precision *int64 `locationName:"precision" type:"integer"`

	// The scale value of a decimal number column.
	Scale *int64 `locationName:"scale" type:"integer"`

	// The name of the schema that owns the table that includes the column.
	SchemaName *string `locationName:"schemaName" type:"string"`

	// The name of the table that includes the column.
	TableName *string `locationName:"tableName" type:"string"`

	// The type of the column.
	Type *int64 `locationName:"type" type:"integer"`

	// The database-specific data type of the column.
	TypeName *string `locationName:"typeName" type:"string"`
}

// String returns the string representation
func (s ColumnMetadata) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ColumnMetadata) MarshalFields(e protocol.FieldEncoder) error {
	if s.ArrayBaseColumnType != nil {
		v := *s.ArrayBaseColumnType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arrayBaseColumnType", protocol.Int64Value(v), metadata)
	}
	if s.IsAutoIncrement != nil {
		v := *s.IsAutoIncrement

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "isAutoIncrement", protocol.BoolValue(v), metadata)
	}
	if s.IsCaseSensitive != nil {
		v := *s.IsCaseSensitive

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "isCaseSensitive", protocol.BoolValue(v), metadata)
	}
	if s.IsCurrency != nil {
		v := *s.IsCurrency

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "isCurrency", protocol.BoolValue(v), metadata)
	}
	if s.IsSigned != nil {
		v := *s.IsSigned

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "isSigned", protocol.BoolValue(v), metadata)
	}
	if s.Label != nil {
		v := *s.Label

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "label", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Nullable != nil {
		v := *s.Nullable

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nullable", protocol.Int64Value(v), metadata)
	}
	if s.Precision != nil {
		v := *s.Precision

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "precision", protocol.Int64Value(v), metadata)
	}
	if s.Scale != nil {
		v := *s.Scale

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "scale", protocol.Int64Value(v), metadata)
	}
	if s.SchemaName != nil {
		v := *s.SchemaName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "schemaName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TableName != nil {
		v := *s.TableName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "tableName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.Int64Value(v), metadata)
	}
	if s.TypeName != nil {
		v := *s.TypeName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "typeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains a value.
type Field struct {
	_ struct{} `type:"structure"`

	// An array of values.
	ArrayValue *ArrayValue `locationName:"arrayValue" type:"structure"`

	// A value of BLOB data type.
	//
	// BlobValue is automatically base64 encoded/decoded by the SDK.
	BlobValue []byte `locationName:"blobValue" type:"blob"`

	// A value of Boolean data type.
	BooleanValue *bool `locationName:"booleanValue" type:"boolean"`

	// A value of double data type.
	DoubleValue *float64 `locationName:"doubleValue" type:"double"`

	// A NULL value.
	IsNull *bool `locationName:"isNull" type:"boolean"`

	// A value of long data type.
	LongValue *int64 `locationName:"longValue" type:"long"`

	// A value of string data type.
	StringValue *string `locationName:"stringValue" type:"string"`
}

// String returns the string representation
func (s Field) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Field) MarshalFields(e protocol.FieldEncoder) error {
	if s.ArrayValue != nil {
		v := s.ArrayValue

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "arrayValue", v, metadata)
	}
	if s.BlobValue != nil {
		v := s.BlobValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "blobValue", protocol.QuotedValue{ValueMarshaler: protocol.BytesValue(v)}, metadata)
	}
	if s.BooleanValue != nil {
		v := *s.BooleanValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "booleanValue", protocol.BoolValue(v), metadata)
	}
	if s.DoubleValue != nil {
		v := *s.DoubleValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "doubleValue", protocol.Float64Value(v), metadata)
	}
	if s.IsNull != nil {
		v := *s.IsNull

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "isNull", protocol.BoolValue(v), metadata)
	}
	if s.LongValue != nil {
		v := *s.LongValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "longValue", protocol.Int64Value(v), metadata)
	}
	if s.StringValue != nil {
		v := *s.StringValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stringValue", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A record returned by a call.
type Record struct {
	_ struct{} `type:"structure"`

	// The values returned in the record.
	Values []Value `locationName:"values" type:"list"`
}

// String returns the string representation
func (s Record) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Record) MarshalFields(e protocol.FieldEncoder) error {
	if s.Values != nil {
		v := s.Values

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "values", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// The result set returned by a SQL statement.
type ResultFrame struct {
	_ struct{} `type:"structure"`

	// The records in the result set.
	Records []Record `locationName:"records" type:"list"`

	// The result-set metadata in the result set.
	ResultSetMetadata *ResultSetMetadata `locationName:"resultSetMetadata" type:"structure"`
}

// String returns the string representation
func (s ResultFrame) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResultFrame) MarshalFields(e protocol.FieldEncoder) error {
	if s.Records != nil {
		v := s.Records

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "records", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ResultSetMetadata != nil {
		v := s.ResultSetMetadata

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "resultSetMetadata", v, metadata)
	}
	return nil
}

// The metadata of the result set returned by a SQL statement.
type ResultSetMetadata struct {
	_ struct{} `type:"structure"`

	// The number of columns in the result set.
	ColumnCount *int64 `locationName:"columnCount" type:"long"`

	// The metadata of the columns in the result set.
	ColumnMetadata []ColumnMetadata `locationName:"columnMetadata" type:"list"`
}

// String returns the string representation
func (s ResultSetMetadata) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResultSetMetadata) MarshalFields(e protocol.FieldEncoder) error {
	if s.ColumnCount != nil {
		v := *s.ColumnCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "columnCount", protocol.Int64Value(v), metadata)
	}
	if s.ColumnMetadata != nil {
		v := s.ColumnMetadata

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "columnMetadata", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Options that control how the result set is returned.
type ResultSetOptions struct {
	_ struct{} `type:"structure"`

	// A value that indicates how a field of DECIMAL type is represented in the
	// response. The value of STRING, the default, specifies that it is converted
	// to a String value. The value of DOUBLE_OR_LONG specifies that it is converted
	// to a Long value if its scale is 0, or to a Double value otherwise.
	//
	// Conversion to Double or Long can result in roundoff errors due to precision
	// loss. We recommend converting to String, especially when working with currency
	// values.
	DecimalReturnType DecimalReturnType `locationName:"decimalReturnType" type:"string" enum:"true"`
}

// String returns the string representation
func (s ResultSetOptions) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResultSetOptions) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.DecimalReturnType) > 0 {
		v := s.DecimalReturnType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "decimalReturnType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// A parameter used in a SQL statement.
type SqlParameter struct {
	_ struct{} `type:"structure"`

	// The name of the parameter.
	Name *string `locationName:"name" type:"string"`

	// A hint that specifies the correct object type for data type mapping.
	//
	// Values:
	//
	//    * DECIMAL - The corresponding String parameter value is sent as an object
	//    of DECIMAL type to the database.
	//
	//    * TIMESTAMP - The corresponding String parameter value is sent as an object
	//    of TIMESTAMP type to the database. The accepted format is YYYY-MM-DD HH:MM:SS[.FFF].
	//
	//    * TIME - The corresponding String parameter value is sent as an object
	//    of TIME type to the database. The accepted format is HH:MM:SS[.FFF].
	//
	//    * DATE - The corresponding String parameter value is sent as an object
	//    of DATE type to the database. The accepted format is YYYY-MM-DD.
	TypeHint TypeHint `locationName:"typeHint" type:"string" enum:"true"`

	// The value of the parameter.
	Value *Field `locationName:"value" type:"structure"`
}

// String returns the string representation
func (s SqlParameter) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SqlParameter) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.TypeHint) > 0 {
		v := s.TypeHint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "typeHint", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Value != nil {
		v := s.Value

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "value", v, metadata)
	}
	return nil
}

// The result of a SQL statement.
//
//    <important> <p>This data type is deprecated.</p> </important>
type SqlStatementResult struct {
	_ struct{} `type:"structure"`

	// The number of records updated by a SQL statement.
	NumberOfRecordsUpdated *int64 `locationName:"numberOfRecordsUpdated" type:"long"`

	// The result set of the SQL statement.
	ResultFrame *ResultFrame `locationName:"resultFrame" type:"structure"`
}

// String returns the string representation
func (s SqlStatementResult) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SqlStatementResult) MarshalFields(e protocol.FieldEncoder) error {
	if s.NumberOfRecordsUpdated != nil {
		v := *s.NumberOfRecordsUpdated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "numberOfRecordsUpdated", protocol.Int64Value(v), metadata)
	}
	if s.ResultFrame != nil {
		v := s.ResultFrame

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "resultFrame", v, metadata)
	}
	return nil
}

// A structure value returned by a call.
type StructValue struct {
	_ struct{} `type:"structure"`

	// The attributes returned in the record.
	Attributes []Value `locationName:"attributes" type:"list"`
}

// String returns the string representation
func (s StructValue) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StructValue) MarshalFields(e protocol.FieldEncoder) error {
	if s.Attributes != nil {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "attributes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// The response elements represent the results of an update.
type UpdateResult struct {
	_ struct{} `type:"structure"`

	// Values for fields generated during the request.
	GeneratedFields []Field `locationName:"generatedFields" type:"list"`
}

// String returns the string representation
func (s UpdateResult) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateResult) MarshalFields(e protocol.FieldEncoder) error {
	if s.GeneratedFields != nil {
		v := s.GeneratedFields

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "generatedFields", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Contains the value of a column.
//
//    <important> <p>This data type is deprecated.</p> </important>
type Value struct {
	_ struct{} `type:"structure"`

	// An array of column values.
	ArrayValues []Value `locationName:"arrayValues" type:"list"`

	// A value for a column of big integer data type.
	BigIntValue *int64 `locationName:"bigIntValue" type:"long"`

	// A value for a column of BIT data type.
	BitValue *bool `locationName:"bitValue" type:"boolean"`

	// A value for a column of BLOB data type.
	//
	// BlobValue is automatically base64 encoded/decoded by the SDK.
	BlobValue []byte `locationName:"blobValue" type:"blob"`

	// A value for a column of double data type.
	DoubleValue *float64 `locationName:"doubleValue" type:"double"`

	// A value for a column of integer data type.
	IntValue *int64 `locationName:"intValue" type:"integer"`

	// A NULL value.
	IsNull *bool `locationName:"isNull" type:"boolean"`

	// A value for a column of real data type.
	RealValue *float64 `locationName:"realValue" type:"float"`

	// A value for a column of string data type.
	StringValue *string `locationName:"stringValue" type:"string"`

	// A value for a column of STRUCT data type.
	StructValue *StructValue `locationName:"structValue" type:"structure"`
}

// String returns the string representation
func (s Value) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Value) MarshalFields(e protocol.FieldEncoder) error {
	if s.ArrayValues != nil {
		v := s.ArrayValues

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "arrayValues", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.BigIntValue != nil {
		v := *s.BigIntValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bigIntValue", protocol.Int64Value(v), metadata)
	}
	if s.BitValue != nil {
		v := *s.BitValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bitValue", protocol.BoolValue(v), metadata)
	}
	if s.BlobValue != nil {
		v := s.BlobValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "blobValue", protocol.QuotedValue{ValueMarshaler: protocol.BytesValue(v)}, metadata)
	}
	if s.DoubleValue != nil {
		v := *s.DoubleValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "doubleValue", protocol.Float64Value(v), metadata)
	}
	if s.IntValue != nil {
		v := *s.IntValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "intValue", protocol.Int64Value(v), metadata)
	}
	if s.IsNull != nil {
		v := *s.IsNull

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "isNull", protocol.BoolValue(v), metadata)
	}
	if s.RealValue != nil {
		v := *s.RealValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "realValue", protocol.Float64Value(v), metadata)
	}
	if s.StringValue != nil {
		v := *s.StringValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stringValue", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StructValue != nil {
		v := s.StructValue

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "structValue", v, metadata)
	}
	return nil
}
