// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeDataSetInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the dataset that you want to create. This ID is unique per AWS
	// Region for each AWS account.
	//
	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDataSetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDataSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeDataSetInput"}

	if s.AwsAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsAccountId", 12))
	}

	if s.DataSetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeDataSetInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DataSetId != nil {
		v := *s.DataSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "DataSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeDataSetOutput struct {
	_ struct{} `type:"structure"`

	// Information on the dataset.
	DataSet *DataSet `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s DescribeDataSetOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeDataSetOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataSet != nil {
		v := s.DataSet

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DataSet", v, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	// ignoring invalid encode state, StatusCode. Status
	return nil
}

const opDescribeDataSet = "DescribeDataSet"

// DescribeDataSetRequest returns a request value for making API operation for
// Amazon QuickSight.
//
// Describes a dataset.
//
//    // Example sending a request using DescribeDataSetRequest.
//    req := client.DescribeDataSetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSet
func (c *Client) DescribeDataSetRequest(input *DescribeDataSetInput) DescribeDataSetRequest {
	op := &aws.Operation{
		Name:       opDescribeDataSet,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}",
	}

	if input == nil {
		input = &DescribeDataSetInput{}
	}

	req := c.newRequest(op, input, &DescribeDataSetOutput{})
	return DescribeDataSetRequest{Request: req, Input: input, Copy: c.DescribeDataSetRequest}
}

// DescribeDataSetRequest is the request type for the
// DescribeDataSet API operation.
type DescribeDataSetRequest struct {
	*aws.Request
	Input *DescribeDataSetInput
	Copy  func(*DescribeDataSetInput) DescribeDataSetRequest
}

// Send marshals and sends the DescribeDataSet API request.
func (r DescribeDataSetRequest) Send(ctx context.Context) (*DescribeDataSetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDataSetResponse{
		DescribeDataSetOutput: r.Request.Data.(*DescribeDataSetOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeDataSetResponse is the response type for the
// DescribeDataSet API operation.
type DescribeDataSetResponse struct {
	*DescribeDataSetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDataSet request.
func (r *DescribeDataSetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
