// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package qldb

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateLedgerInput struct {
	_ struct{} `type:"structure"`

	// The flag that prevents a ledger from being deleted by any user. If not provided
	// on ledger creation, this feature is enabled (true) by default.
	//
	// If deletion protection is enabled, you must first disable it before you can
	// delete the ledger using the QLDB API or the AWS Command Line Interface (AWS
	// CLI). You can disable it by calling the UpdateLedger operation to set the
	// flag to false. The QLDB console disables deletion protection for you when
	// you use it to delete a ledger.
	DeletionProtection *bool `type:"boolean"`

	// The name of the ledger that you want to create. The name must be unique among
	// all of your ledgers in the current AWS Region.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The permissions mode to assign to the ledger that you want to create.
	//
	// PermissionsMode is a required field
	PermissionsMode PermissionsMode `type:"string" required:"true" enum:"true"`

	// The key-value pairs to add as tags to the ledger that you want to create.
	// Tag keys are case sensitive. Tag values are case sensitive and can be null.
	Tags map[string]string `type:"map"`
}

// String returns the string representation
func (s CreateLedgerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLedgerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateLedgerInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if len(s.PermissionsMode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("PermissionsMode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateLedgerInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DeletionProtection != nil {
		v := *s.DeletionProtection

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeletionProtection", protocol.BoolValue(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.PermissionsMode) > 0 {
		v := s.PermissionsMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PermissionsMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

type CreateLedgerOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the ledger.
	Arn *string `min:"20" type:"string"`

	// The date and time, in epoch time format, when the ledger was created. (Epoch
	// time format is the number of seconds elapsed since 12:00:00 AM January 1,
	// 1970 UTC.)
	CreationDateTime *time.Time `type:"timestamp"`

	// The flag that prevents a ledger from being deleted by any user. If not provided
	// on ledger creation, this feature is enabled (true) by default.
	//
	// If deletion protection is enabled, you must first disable it before you can
	// delete the ledger using the QLDB API or the AWS Command Line Interface (AWS
	// CLI). You can disable it by calling the UpdateLedger operation to set the
	// flag to false. The QLDB console disables deletion protection for you when
	// you use it to delete a ledger.
	DeletionProtection *bool `type:"boolean"`

	// The name of the ledger.
	Name *string `min:"1" type:"string"`

	// The current status of the ledger.
	State LedgerState `type:"string" enum:"true"`
}

// String returns the string representation
func (s CreateLedgerOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateLedgerOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDateTime != nil {
		v := *s.CreationDateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDateTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.DeletionProtection != nil {
		v := *s.DeletionProtection

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeletionProtection", protocol.BoolValue(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

const opCreateLedger = "CreateLedger"

// CreateLedgerRequest returns a request value for making API operation for
// Amazon QLDB.
//
// Creates a new ledger in your AWS account.
//
//    // Example sending a request using CreateLedgerRequest.
//    req := client.CreateLedgerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/CreateLedger
func (c *Client) CreateLedgerRequest(input *CreateLedgerInput) CreateLedgerRequest {
	op := &aws.Operation{
		Name:       opCreateLedger,
		HTTPMethod: "POST",
		HTTPPath:   "/ledgers",
	}

	if input == nil {
		input = &CreateLedgerInput{}
	}

	req := c.newRequest(op, input, &CreateLedgerOutput{})
	return CreateLedgerRequest{Request: req, Input: input, Copy: c.CreateLedgerRequest}
}

// CreateLedgerRequest is the request type for the
// CreateLedger API operation.
type CreateLedgerRequest struct {
	*aws.Request
	Input *CreateLedgerInput
	Copy  func(*CreateLedgerInput) CreateLedgerRequest
}

// Send marshals and sends the CreateLedger API request.
func (r CreateLedgerRequest) Send(ctx context.Context) (*CreateLedgerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateLedgerResponse{
		CreateLedgerOutput: r.Request.Data.(*CreateLedgerOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateLedgerResponse is the response type for the
// CreateLedger API operation.
type CreateLedgerResponse struct {
	*CreateLedgerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateLedger request.
func (r *CreateLedgerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
