// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package outposts

import (
	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Information about an instance type.
type InstanceTypeItem struct {
	_ struct{} `type:"structure"`

	// The instance type.
	InstanceType *string `type:"string"`
}

// String returns the string representation
func (s InstanceTypeItem) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InstanceTypeItem) MarshalFields(e protocol.FieldEncoder) error {
	if s.InstanceType != nil {
		v := *s.InstanceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InstanceType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about an Outpost.
type Outpost struct {
	_ struct{} `type:"structure"`

	// The Availability Zone.
	AvailabilityZone *string `min:"1" type:"string"`

	// The ID of the Availability Zone.
	AvailabilityZoneId *string `min:"1" type:"string"`

	// The Outpost description.
	Description *string `min:"1" type:"string"`

	// The life cycle status.
	LifeCycleStatus *string `type:"string"`

	// The name of the Outpost.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the Outpost.
	OutpostArn *string `min:"1" type:"string"`

	// The ID of the Outpost.
	OutpostId *string `min:"1" type:"string"`

	// The AWS account ID of the Outpost owner.
	OwnerId *string `min:"12" type:"string"`

	// The ID of the site.
	SiteId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Outpost) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Outpost) MarshalFields(e protocol.FieldEncoder) error {
	if s.AvailabilityZone != nil {
		v := *s.AvailabilityZone

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AvailabilityZone", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AvailabilityZoneId != nil {
		v := *s.AvailabilityZoneId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AvailabilityZoneId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LifeCycleStatus != nil {
		v := *s.LifeCycleStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LifeCycleStatus", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OutpostArn != nil {
		v := *s.OutpostArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OutpostArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OutpostId != nil {
		v := *s.OutpostId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OutpostId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OwnerId != nil {
		v := *s.OwnerId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OwnerId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SiteId != nil {
		v := *s.SiteId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SiteId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a site.
type Site struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS account.
	AccountId *string `min:"12" type:"string"`

	// The description of the site.
	Description *string `min:"1" type:"string"`

	// The name of the site.
	Name *string `min:"1" type:"string"`

	// The ID of the site.
	SiteId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Site) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Site) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SiteId != nil {
		v := *s.SiteId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SiteId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
