// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeTimeBasedAutoScalingInput struct {
	_ struct{} `type:"structure"`

	// An array of instance IDs.
	//
	// InstanceIds is a required field
	InstanceIds []string `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeTimeBasedAutoScalingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTimeBasedAutoScalingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeTimeBasedAutoScalingInput"}

	if s.InstanceIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the response to a DescribeTimeBasedAutoScaling request.
type DescribeTimeBasedAutoScalingOutput struct {
	_ struct{} `type:"structure"`

	// An array of TimeBasedAutoScalingConfiguration objects that describe the configuration
	// for the specified instances.
	TimeBasedAutoScalingConfigurations []TimeBasedAutoScalingConfiguration `type:"list"`
}

// String returns the string representation
func (s DescribeTimeBasedAutoScalingOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeTimeBasedAutoScaling = "DescribeTimeBasedAutoScaling"

// DescribeTimeBasedAutoScalingRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Describes time-based auto scaling configurations for specified instances.
//
// You must specify at least one of the parameters.
//
// Required Permissions: To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack, or an attached policy that explicitly
// grants permissions. For more information about user permissions, see Managing
// User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
//    // Example sending a request using DescribeTimeBasedAutoScalingRequest.
//    req := client.DescribeTimeBasedAutoScalingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeTimeBasedAutoScaling
func (c *Client) DescribeTimeBasedAutoScalingRequest(input *DescribeTimeBasedAutoScalingInput) DescribeTimeBasedAutoScalingRequest {
	op := &aws.Operation{
		Name:       opDescribeTimeBasedAutoScaling,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTimeBasedAutoScalingInput{}
	}

	req := c.newRequest(op, input, &DescribeTimeBasedAutoScalingOutput{})
	return DescribeTimeBasedAutoScalingRequest{Request: req, Input: input, Copy: c.DescribeTimeBasedAutoScalingRequest}
}

// DescribeTimeBasedAutoScalingRequest is the request type for the
// DescribeTimeBasedAutoScaling API operation.
type DescribeTimeBasedAutoScalingRequest struct {
	*aws.Request
	Input *DescribeTimeBasedAutoScalingInput
	Copy  func(*DescribeTimeBasedAutoScalingInput) DescribeTimeBasedAutoScalingRequest
}

// Send marshals and sends the DescribeTimeBasedAutoScaling API request.
func (r DescribeTimeBasedAutoScalingRequest) Send(ctx context.Context) (*DescribeTimeBasedAutoScalingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeTimeBasedAutoScalingResponse{
		DescribeTimeBasedAutoScalingOutput: r.Request.Data.(*DescribeTimeBasedAutoScalingOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeTimeBasedAutoScalingResponse is the response type for the
// DescribeTimeBasedAutoScaling API operation.
type DescribeTimeBasedAutoScalingResponse struct {
	*DescribeTimeBasedAutoScalingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeTimeBasedAutoScaling request.
func (r *DescribeTimeBasedAutoScalingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
