// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeServiceErrorsInput struct {
	_ struct{} `type:"structure"`

	// The instance ID. If you use this parameter, DescribeServiceErrors returns
	// descriptions of the errors associated with the specified instance.
	InstanceId *string `type:"string"`

	// An array of service error IDs. If you use this parameter, DescribeServiceErrors
	// returns descriptions of the specified errors. Otherwise, it returns a description
	// of every error.
	ServiceErrorIds []string `type:"list"`

	// The stack ID. If you use this parameter, DescribeServiceErrors returns descriptions
	// of the errors associated with the specified stack.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s DescribeServiceErrorsInput) String() string {
	return awsutil.Prettify(s)
}

// Contains the response to a DescribeServiceErrors request.
type DescribeServiceErrorsOutput struct {
	_ struct{} `type:"structure"`

	// An array of ServiceError objects that describe the specified service errors.
	ServiceErrors []ServiceError `type:"list"`
}

// String returns the string representation
func (s DescribeServiceErrorsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeServiceErrors = "DescribeServiceErrors"

// DescribeServiceErrorsRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Describes AWS OpsWorks Stacks service errors.
//
// Required Permissions: To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack, or an attached policy that explicitly
// grants permissions. For more information about user permissions, see Managing
// User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// This call accepts only one resource-identifying parameter.
//
//    // Example sending a request using DescribeServiceErrorsRequest.
//    req := client.DescribeServiceErrorsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeServiceErrors
func (c *Client) DescribeServiceErrorsRequest(input *DescribeServiceErrorsInput) DescribeServiceErrorsRequest {
	op := &aws.Operation{
		Name:       opDescribeServiceErrors,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeServiceErrorsInput{}
	}

	req := c.newRequest(op, input, &DescribeServiceErrorsOutput{})
	return DescribeServiceErrorsRequest{Request: req, Input: input, Copy: c.DescribeServiceErrorsRequest}
}

// DescribeServiceErrorsRequest is the request type for the
// DescribeServiceErrors API operation.
type DescribeServiceErrorsRequest struct {
	*aws.Request
	Input *DescribeServiceErrorsInput
	Copy  func(*DescribeServiceErrorsInput) DescribeServiceErrorsRequest
}

// Send marshals and sends the DescribeServiceErrors API request.
func (r DescribeServiceErrorsRequest) Send(ctx context.Context) (*DescribeServiceErrorsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeServiceErrorsResponse{
		DescribeServiceErrorsOutput: r.Request.Data.(*DescribeServiceErrorsOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeServiceErrorsResponse is the response type for the
// DescribeServiceErrors API operation.
type DescribeServiceErrorsResponse struct {
	*DescribeServiceErrorsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeServiceErrors request.
func (r *DescribeServiceErrorsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
