// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeOperatingSystemsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeOperatingSystemsInput) String() string {
	return awsutil.Prettify(s)
}

// The response to a DescribeOperatingSystems request.
type DescribeOperatingSystemsOutput struct {
	_ struct{} `type:"structure"`

	// Contains information in response to a DescribeOperatingSystems request.
	OperatingSystems []OperatingSystem `type:"list"`
}

// String returns the string representation
func (s DescribeOperatingSystemsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeOperatingSystems = "DescribeOperatingSystems"

// DescribeOperatingSystemsRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Describes the operating systems that are supported by AWS OpsWorks Stacks.
//
//    // Example sending a request using DescribeOperatingSystemsRequest.
//    req := client.DescribeOperatingSystemsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeOperatingSystems
func (c *Client) DescribeOperatingSystemsRequest(input *DescribeOperatingSystemsInput) DescribeOperatingSystemsRequest {
	op := &aws.Operation{
		Name:       opDescribeOperatingSystems,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeOperatingSystemsInput{}
	}

	req := c.newRequest(op, input, &DescribeOperatingSystemsOutput{})
	return DescribeOperatingSystemsRequest{Request: req, Input: input, Copy: c.DescribeOperatingSystemsRequest}
}

// DescribeOperatingSystemsRequest is the request type for the
// DescribeOperatingSystems API operation.
type DescribeOperatingSystemsRequest struct {
	*aws.Request
	Input *DescribeOperatingSystemsInput
	Copy  func(*DescribeOperatingSystemsInput) DescribeOperatingSystemsRequest
}

// Send marshals and sends the DescribeOperatingSystems API request.
func (r DescribeOperatingSystemsRequest) Send(ctx context.Context) (*DescribeOperatingSystemsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeOperatingSystemsResponse{
		DescribeOperatingSystemsOutput: r.Request.Data.(*DescribeOperatingSystemsOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeOperatingSystemsResponse is the response type for the
// DescribeOperatingSystems API operation.
type DescribeOperatingSystemsResponse struct {
	*DescribeOperatingSystemsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeOperatingSystems request.
func (r *DescribeOperatingSystemsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
