// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package networkmanager

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type AssociateCustomerGatewayInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the customer gateway. For more information,
	// see Resources Defined by Amazon EC2 (https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonec2.html#amazonec2-resources-for-iam-policies).
	//
	// CustomerGatewayArn is a required field
	CustomerGatewayArn *string `type:"string" required:"true"`

	// The ID of the device.
	//
	// DeviceId is a required field
	DeviceId *string `type:"string" required:"true"`

	// The ID of the global network.
	//
	// GlobalNetworkId is a required field
	GlobalNetworkId *string `location:"uri" locationName:"globalNetworkId" type:"string" required:"true"`

	// The ID of the link.
	LinkId *string `type:"string"`
}

// String returns the string representation
func (s AssociateCustomerGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateCustomerGatewayInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociateCustomerGatewayInput"}

	if s.CustomerGatewayArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("CustomerGatewayArn"))
	}

	if s.DeviceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeviceId"))
	}

	if s.GlobalNetworkId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GlobalNetworkId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssociateCustomerGatewayInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.CustomerGatewayArn != nil {
		v := *s.CustomerGatewayArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CustomerGatewayArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeviceId != nil {
		v := *s.DeviceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeviceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LinkId != nil {
		v := *s.LinkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LinkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GlobalNetworkId != nil {
		v := *s.GlobalNetworkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "globalNetworkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type AssociateCustomerGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The customer gateway association.
	CustomerGatewayAssociation *CustomerGatewayAssociation `type:"structure"`
}

// String returns the string representation
func (s AssociateCustomerGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssociateCustomerGatewayOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CustomerGatewayAssociation != nil {
		v := s.CustomerGatewayAssociation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CustomerGatewayAssociation", v, metadata)
	}
	return nil
}

const opAssociateCustomerGateway = "AssociateCustomerGateway"

// AssociateCustomerGatewayRequest returns a request value for making API operation for
// AWS Network Manager.
//
// Associates a customer gateway with a device and optionally, with a link.
// If you specify a link, it must be associated with the specified device.
//
// You can only associate customer gateways that are connected to a VPN attachment
// on a transit gateway. The transit gateway must be registered in your global
// network. When you register a transit gateway, customer gateways that are
// connected to the transit gateway are automatically included in the global
// network. To list customer gateways that are connected to a transit gateway,
// use the DescribeVpnConnections (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpnConnections.html)
// EC2 API and filter by transit-gateway-id.
//
// You cannot associate a customer gateway with more than one device and link.
//
//    // Example sending a request using AssociateCustomerGatewayRequest.
//    req := client.AssociateCustomerGatewayRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/AssociateCustomerGateway
func (c *Client) AssociateCustomerGatewayRequest(input *AssociateCustomerGatewayInput) AssociateCustomerGatewayRequest {
	op := &aws.Operation{
		Name:       opAssociateCustomerGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/global-networks/{globalNetworkId}/customer-gateway-associations",
	}

	if input == nil {
		input = &AssociateCustomerGatewayInput{}
	}

	req := c.newRequest(op, input, &AssociateCustomerGatewayOutput{})
	return AssociateCustomerGatewayRequest{Request: req, Input: input, Copy: c.AssociateCustomerGatewayRequest}
}

// AssociateCustomerGatewayRequest is the request type for the
// AssociateCustomerGateway API operation.
type AssociateCustomerGatewayRequest struct {
	*aws.Request
	Input *AssociateCustomerGatewayInput
	Copy  func(*AssociateCustomerGatewayInput) AssociateCustomerGatewayRequest
}

// Send marshals and sends the AssociateCustomerGateway API request.
func (r AssociateCustomerGatewayRequest) Send(ctx context.Context) (*AssociateCustomerGatewayResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AssociateCustomerGatewayResponse{
		AssociateCustomerGatewayOutput: r.Request.Data.(*AssociateCustomerGatewayOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AssociateCustomerGatewayResponse is the response type for the
// AssociateCustomerGateway API operation.
type AssociateCustomerGatewayResponse struct {
	*AssociateCustomerGatewayOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AssociateCustomerGateway request.
func (r *AssociateCustomerGatewayResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
