// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package migrationhub

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListProgressUpdateStreamsInput struct {
	_ struct{} `type:"structure"`

	// Filter to limit the maximum number of results to list per page.
	MaxResults *int64 `min:"1" type:"integer"`

	// If a NextToken was returned by a previous call, there are more results available.
	// To retrieve the next page of results, make the call again using the returned
	// token in NextToken.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListProgressUpdateStreamsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProgressUpdateStreamsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListProgressUpdateStreamsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListProgressUpdateStreamsOutput struct {
	_ struct{} `type:"structure"`

	// If there are more streams created than the max result, return the next token
	// to be passed to the next call as a bookmark of where to start from.
	NextToken *string `type:"string"`

	// List of progress update streams up to the max number of results passed in
	// the input.
	ProgressUpdateStreamSummaryList []ProgressUpdateStreamSummary `type:"list"`
}

// String returns the string representation
func (s ListProgressUpdateStreamsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListProgressUpdateStreams = "ListProgressUpdateStreams"

// ListProgressUpdateStreamsRequest returns a request value for making API operation for
// AWS Migration Hub.
//
// Lists progress update streams associated with the user account making this
// call.
//
//    // Example sending a request using ListProgressUpdateStreamsRequest.
//    req := client.ListProgressUpdateStreamsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListProgressUpdateStreams
func (c *Client) ListProgressUpdateStreamsRequest(input *ListProgressUpdateStreamsInput) ListProgressUpdateStreamsRequest {
	op := &aws.Operation{
		Name:       opListProgressUpdateStreams,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProgressUpdateStreamsInput{}
	}

	req := c.newRequest(op, input, &ListProgressUpdateStreamsOutput{})
	return ListProgressUpdateStreamsRequest{Request: req, Input: input, Copy: c.ListProgressUpdateStreamsRequest}
}

// ListProgressUpdateStreamsRequest is the request type for the
// ListProgressUpdateStreams API operation.
type ListProgressUpdateStreamsRequest struct {
	*aws.Request
	Input *ListProgressUpdateStreamsInput
	Copy  func(*ListProgressUpdateStreamsInput) ListProgressUpdateStreamsRequest
}

// Send marshals and sends the ListProgressUpdateStreams API request.
func (r ListProgressUpdateStreamsRequest) Send(ctx context.Context) (*ListProgressUpdateStreamsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListProgressUpdateStreamsResponse{
		ListProgressUpdateStreamsOutput: r.Request.Data.(*ListProgressUpdateStreamsOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListProgressUpdateStreamsRequestPaginator returns a paginator for ListProgressUpdateStreams.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListProgressUpdateStreamsRequest(input)
//   p := migrationhub.NewListProgressUpdateStreamsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListProgressUpdateStreamsPaginator(req ListProgressUpdateStreamsRequest) ListProgressUpdateStreamsPaginator {
	return ListProgressUpdateStreamsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListProgressUpdateStreamsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListProgressUpdateStreamsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListProgressUpdateStreamsPaginator struct {
	aws.Pager
}

func (p *ListProgressUpdateStreamsPaginator) CurrentPage() *ListProgressUpdateStreamsOutput {
	return p.Pager.CurrentPage().(*ListProgressUpdateStreamsOutput)
}

// ListProgressUpdateStreamsResponse is the response type for the
// ListProgressUpdateStreams API operation.
type ListProgressUpdateStreamsResponse struct {
	*ListProgressUpdateStreamsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListProgressUpdateStreams request.
func (r *ListProgressUpdateStreamsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
