// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package marketplacemetering

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains input to the ResolveCustomer operation.
type ResolveCustomerInput struct {
	_ struct{} `type:"structure"`

	// When a buyer visits your website during the registration process, the buyer
	// submits a registration token through the browser. The registration token
	// is resolved to obtain a CustomerIdentifier and product code.
	//
	// RegistrationToken is a required field
	RegistrationToken *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ResolveCustomerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResolveCustomerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResolveCustomerInput"}

	if s.RegistrationToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("RegistrationToken"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of the ResolveCustomer operation. Contains the CustomerIdentifier
// and product code.
type ResolveCustomerOutput struct {
	_ struct{} `type:"structure"`

	// The CustomerIdentifier is used to identify an individual customer in your
	// application. Calls to BatchMeterUsage require CustomerIdentifiers for each
	// UsageRecord.
	CustomerIdentifier *string `min:"1" type:"string"`

	// The product code is returned to confirm that the buyer is registering for
	// your product. Subsequent BatchMeterUsage calls should be made using this
	// product code.
	ProductCode *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ResolveCustomerOutput) String() string {
	return awsutil.Prettify(s)
}

const opResolveCustomer = "ResolveCustomer"

// ResolveCustomerRequest returns a request value for making API operation for
// AWSMarketplace Metering.
//
// ResolveCustomer is called by a SaaS application during the registration process.
// When a buyer visits your website during the registration process, the buyer
// submits a registration token through their browser. The registration token
// is resolved through this API to obtain a CustomerIdentifier and product code.
//
//    // Example sending a request using ResolveCustomerRequest.
//    req := client.ResolveCustomerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/meteringmarketplace-2016-01-14/ResolveCustomer
func (c *Client) ResolveCustomerRequest(input *ResolveCustomerInput) ResolveCustomerRequest {
	op := &aws.Operation{
		Name:       opResolveCustomer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResolveCustomerInput{}
	}

	req := c.newRequest(op, input, &ResolveCustomerOutput{})
	return ResolveCustomerRequest{Request: req, Input: input, Copy: c.ResolveCustomerRequest}
}

// ResolveCustomerRequest is the request type for the
// ResolveCustomer API operation.
type ResolveCustomerRequest struct {
	*aws.Request
	Input *ResolveCustomerInput
	Copy  func(*ResolveCustomerInput) ResolveCustomerRequest
}

// Send marshals and sends the ResolveCustomer API request.
func (r ResolveCustomerRequest) Send(ctx context.Context) (*ResolveCustomerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ResolveCustomerResponse{
		ResolveCustomerOutput: r.Request.Data.(*ResolveCustomerOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ResolveCustomerResponse is the response type for the
// ResolveCustomer API operation.
type ResolveCustomerResponse struct {
	*ResolveCustomerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ResolveCustomer request.
func (r *ResolveCustomerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
