// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UnpeerVpcInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UnpeerVpcInput) String() string {
	return awsutil.Prettify(s)
}

type UnpeerVpcOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the request operation.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s UnpeerVpcOutput) String() string {
	return awsutil.Prettify(s)
}

const opUnpeerVpc = "UnpeerVpc"

// UnpeerVpcRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Attempts to unpeer the Lightsail VPC from the user's default VPC.
//
//    // Example sending a request using UnpeerVpcRequest.
//    req := client.UnpeerVpcRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UnpeerVpc
func (c *Client) UnpeerVpcRequest(input *UnpeerVpcInput) UnpeerVpcRequest {
	op := &aws.Operation{
		Name:       opUnpeerVpc,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnpeerVpcInput{}
	}

	req := c.newRequest(op, input, &UnpeerVpcOutput{})
	return UnpeerVpcRequest{Request: req, Input: input, Copy: c.UnpeerVpcRequest}
}

// UnpeerVpcRequest is the request type for the
// UnpeerVpc API operation.
type UnpeerVpcRequest struct {
	*aws.Request
	Input *UnpeerVpcInput
	Copy  func(*UnpeerVpcInput) UnpeerVpcRequest
}

// Send marshals and sends the UnpeerVpc API request.
func (r UnpeerVpcRequest) Send(ctx context.Context) (*UnpeerVpcResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UnpeerVpcResponse{
		UnpeerVpcOutput: r.Request.Data.(*UnpeerVpcOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UnpeerVpcResponse is the response type for the
// UnpeerVpc API operation.
type UnpeerVpcResponse struct {
	*UnpeerVpcOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UnpeerVpc request.
func (r *UnpeerVpcResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
