// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetBundlesInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value that indicates whether to include inactive bundle results
	// in your request.
	IncludeInactive *bool `locationName:"includeInactive" type:"boolean"`

	// A token used for advancing to the next page of results from your get bundles
	// request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetBundlesInput) String() string {
	return awsutil.Prettify(s)
}

type GetBundlesOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs that contains information about the available
	// bundles.
	Bundles []Bundle `locationName:"bundles" type:"list"`

	// A token used for advancing to the next page of results from your get active
	// names request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetBundlesOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetBundles = "GetBundles"

// GetBundlesRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Returns the list of bundles that are available for purchase. A bundle describes
// the specs for your virtual private server (or instance).
//
//    // Example sending a request using GetBundlesRequest.
//    req := client.GetBundlesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBundles
func (c *Client) GetBundlesRequest(input *GetBundlesInput) GetBundlesRequest {
	op := &aws.Operation{
		Name:       opGetBundles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetBundlesInput{}
	}

	req := c.newRequest(op, input, &GetBundlesOutput{})
	return GetBundlesRequest{Request: req, Input: input, Copy: c.GetBundlesRequest}
}

// GetBundlesRequest is the request type for the
// GetBundles API operation.
type GetBundlesRequest struct {
	*aws.Request
	Input *GetBundlesInput
	Copy  func(*GetBundlesInput) GetBundlesRequest
}

// Send marshals and sends the GetBundles API request.
func (r GetBundlesRequest) Send(ctx context.Context) (*GetBundlesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetBundlesResponse{
		GetBundlesOutput: r.Request.Data.(*GetBundlesOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetBundlesResponse is the response type for the
// GetBundles API operation.
type GetBundlesResponse struct {
	*GetBundlesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetBundles request.
func (r *GetBundlesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
