// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotevents

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteDetectorModelInput struct {
	_ struct{} `type:"structure"`

	// The name of the detector model to be deleted.
	//
	// DetectorModelName is a required field
	DetectorModelName *string `location:"uri" locationName:"detectorModelName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDetectorModelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDetectorModelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteDetectorModelInput"}

	if s.DetectorModelName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DetectorModelName"))
	}
	if s.DetectorModelName != nil && len(*s.DetectorModelName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DetectorModelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteDetectorModelInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DetectorModelName != nil {
		v := *s.DetectorModelName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "detectorModelName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteDetectorModelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDetectorModelOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteDetectorModelOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteDetectorModel = "DeleteDetectorModel"

// DeleteDetectorModelRequest returns a request value for making API operation for
// AWS IoT Events.
//
// Deletes a detector model. Any active instances of the detector model are
// also deleted.
//
//    // Example sending a request using DeleteDetectorModelRequest.
//    req := client.DeleteDetectorModelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DeleteDetectorModel
func (c *Client) DeleteDetectorModelRequest(input *DeleteDetectorModelInput) DeleteDetectorModelRequest {
	op := &aws.Operation{
		Name:       opDeleteDetectorModel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/detector-models/{detectorModelName}",
	}

	if input == nil {
		input = &DeleteDetectorModelInput{}
	}

	req := c.newRequest(op, input, &DeleteDetectorModelOutput{})
	return DeleteDetectorModelRequest{Request: req, Input: input, Copy: c.DeleteDetectorModelRequest}
}

// DeleteDetectorModelRequest is the request type for the
// DeleteDetectorModel API operation.
type DeleteDetectorModelRequest struct {
	*aws.Request
	Input *DeleteDetectorModelInput
	Copy  func(*DeleteDetectorModelInput) DeleteDetectorModelRequest
}

// Send marshals and sends the DeleteDetectorModel API request.
func (r DeleteDetectorModelRequest) Send(ctx context.Context) (*DeleteDetectorModelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteDetectorModelResponse{
		DeleteDetectorModelOutput: r.Request.Data.(*DeleteDetectorModelOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteDetectorModelResponse is the response type for the
// DeleteDetectorModel API operation.
type DeleteDetectorModelResponse struct {
	*DeleteDetectorModelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteDetectorModel request.
func (r *DeleteDetectorModelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
