// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package inspector

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Used in the exception error that is thrown if you start an assessment run
// for an assessment target that includes an EC2 instance that is already participating
// in another started assessment run.
type AgentAlreadyRunningAssessment struct {
	_ struct{} `type:"structure"`

	// ID of the agent that is running on an EC2 instance that is already participating
	// in another started assessment run.
	//
	// AgentId is a required field
	AgentId *string `locationName:"agentId" min:"1" type:"string" required:"true"`

	// The ARN of the assessment run that has already been started.
	//
	// AssessmentRunArn is a required field
	AssessmentRunArn *string `locationName:"assessmentRunArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AgentAlreadyRunningAssessment) String() string {
	return awsutil.Prettify(s)
}

// Contains information about an Amazon Inspector agent. This data type is used
// as a request parameter in the ListAssessmentRunAgents action.
type AgentFilter struct {
	_ struct{} `type:"structure"`

	// The detailed health state of the agent. Values can be set to IDLE, RUNNING,
	// SHUTDOWN, UNHEALTHY, THROTTLED, and UNKNOWN.
	//
	// AgentHealthCodes is a required field
	AgentHealthCodes []AgentHealthCode `locationName:"agentHealthCodes" type:"list" required:"true"`

	// The current health state of the agent. Values can be set to HEALTHY or UNHEALTHY.
	//
	// AgentHealths is a required field
	AgentHealths []AgentHealth `locationName:"agentHealths" type:"list" required:"true"`
}

// String returns the string representation
func (s AgentFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AgentFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AgentFilter"}

	if s.AgentHealthCodes == nil {
		invalidParams.Add(aws.NewErrParamRequired("AgentHealthCodes"))
	}

	if s.AgentHealths == nil {
		invalidParams.Add(aws.NewErrParamRequired("AgentHealths"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Used as a response element in the PreviewAgents action.
type AgentPreview struct {
	_ struct{} `type:"structure"`

	// The health status of the Amazon Inspector Agent.
	AgentHealth AgentHealth `locationName:"agentHealth" type:"string" enum:"true"`

	// The ID of the EC2 instance where the agent is installed.
	//
	// AgentId is a required field
	AgentId *string `locationName:"agentId" min:"1" type:"string" required:"true"`

	// The version of the Amazon Inspector Agent.
	AgentVersion *string `locationName:"agentVersion" min:"1" type:"string"`

	// The Auto Scaling group for the EC2 instance where the agent is installed.
	AutoScalingGroup *string `locationName:"autoScalingGroup" min:"1" type:"string"`

	// The hostname of the EC2 instance on which the Amazon Inspector Agent is installed.
	Hostname *string `locationName:"hostname" type:"string"`

	// The IP address of the EC2 instance on which the Amazon Inspector Agent is
	// installed.
	Ipv4Address *string `locationName:"ipv4Address" min:"7" type:"string"`

	// The kernel version of the operating system running on the EC2 instance on
	// which the Amazon Inspector Agent is installed.
	KernelVersion *string `locationName:"kernelVersion" min:"1" type:"string"`

	// The operating system running on the EC2 instance on which the Amazon Inspector
	// Agent is installed.
	OperatingSystem *string `locationName:"operatingSystem" min:"1" type:"string"`
}

// String returns the string representation
func (s AgentPreview) String() string {
	return awsutil.Prettify(s)
}

// A snapshot of an Amazon Inspector assessment run that contains the findings
// of the assessment run .
//
// Used as the response element in the DescribeAssessmentRuns action.
type AssessmentRun struct {
	_ struct{} `type:"structure"`

	// The ARN of the assessment run.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The ARN of the assessment template that is associated with the assessment
	// run.
	//
	// AssessmentTemplateArn is a required field
	AssessmentTemplateArn *string `locationName:"assessmentTemplateArn" min:"1" type:"string" required:"true"`

	// The assessment run completion time that corresponds to the rules packages
	// evaluation completion time or failure.
	CompletedAt *time.Time `locationName:"completedAt" type:"timestamp"`

	// The time when StartAssessmentRun was called.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// A Boolean value (true or false) that specifies whether the process of collecting
	// data from the agents is completed.
	//
	// DataCollected is a required field
	DataCollected *bool `locationName:"dataCollected" type:"boolean" required:"true"`

	// The duration of the assessment run.
	//
	// DurationInSeconds is a required field
	DurationInSeconds *int64 `locationName:"durationInSeconds" min:"180" type:"integer" required:"true"`

	// Provides a total count of generated findings per severity.
	//
	// FindingCounts is a required field
	FindingCounts map[string]int64 `locationName:"findingCounts" type:"map" required:"true"`

	// The auto-generated name for the assessment run.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A list of notifications for the event subscriptions. A notification about
	// a particular generated finding is added to this list only once.
	//
	// Notifications is a required field
	Notifications []AssessmentRunNotification `locationName:"notifications" type:"list" required:"true"`

	// The rules packages selected for the assessment run.
	//
	// RulesPackageArns is a required field
	RulesPackageArns []string `locationName:"rulesPackageArns" min:"1" type:"list" required:"true"`

	// The time when StartAssessmentRun was called.
	StartedAt *time.Time `locationName:"startedAt" type:"timestamp"`

	// The state of the assessment run.
	//
	// State is a required field
	State AssessmentRunState `locationName:"state" type:"string" required:"true" enum:"true"`

	// The last time when the assessment run's state changed.
	//
	// StateChangedAt is a required field
	StateChangedAt *time.Time `locationName:"stateChangedAt" type:"timestamp" required:"true"`

	// A list of the assessment run state changes.
	//
	// StateChanges is a required field
	StateChanges []AssessmentRunStateChange `locationName:"stateChanges" type:"list" required:"true"`

	// The user-defined attributes that are assigned to every generated finding.
	//
	// UserAttributesForFindings is a required field
	UserAttributesForFindings []Attribute `locationName:"userAttributesForFindings" type:"list" required:"true"`
}

// String returns the string representation
func (s AssessmentRun) String() string {
	return awsutil.Prettify(s)
}

// Contains information about an Amazon Inspector agent. This data type is used
// as a response element in the ListAssessmentRunAgents action.
type AssessmentRunAgent struct {
	_ struct{} `type:"structure"`

	// The current health state of the agent.
	//
	// AgentHealth is a required field
	AgentHealth AgentHealth `locationName:"agentHealth" type:"string" required:"true" enum:"true"`

	// The detailed health state of the agent.
	//
	// AgentHealthCode is a required field
	AgentHealthCode AgentHealthCode `locationName:"agentHealthCode" type:"string" required:"true" enum:"true"`

	// The description for the agent health code.
	AgentHealthDetails *string `locationName:"agentHealthDetails" type:"string"`

	// The AWS account of the EC2 instance where the agent is installed.
	//
	// AgentId is a required field
	AgentId *string `locationName:"agentId" min:"1" type:"string" required:"true"`

	// The ARN of the assessment run that is associated with the agent.
	//
	// AssessmentRunArn is a required field
	AssessmentRunArn *string `locationName:"assessmentRunArn" min:"1" type:"string" required:"true"`

	// The Auto Scaling group of the EC2 instance that is specified by the agent
	// ID.
	AutoScalingGroup *string `locationName:"autoScalingGroup" min:"1" type:"string"`

	// The Amazon Inspector application data metrics that are collected by the agent.
	//
	// TelemetryMetadata is a required field
	TelemetryMetadata []TelemetryMetadata `locationName:"telemetryMetadata" type:"list" required:"true"`
}

// String returns the string representation
func (s AssessmentRunAgent) String() string {
	return awsutil.Prettify(s)
}

// Used as the request parameter in the ListAssessmentRuns action.
type AssessmentRunFilter struct {
	_ struct{} `type:"structure"`

	// For a record to match a filter, the value that is specified for this data
	// type property must inclusively match any value between the specified minimum
	// and maximum values of the completedAt property of the AssessmentRun data
	// type.
	CompletionTimeRange *TimestampRange `locationName:"completionTimeRange" type:"structure"`

	// For a record to match a filter, the value that is specified for this data
	// type property must inclusively match any value between the specified minimum
	// and maximum values of the durationInSeconds property of the AssessmentRun
	// data type.
	DurationRange *DurationRange `locationName:"durationRange" type:"structure"`

	// For a record to match a filter, an explicit value or a string containing
	// a wildcard that is specified for this data type property must match the value
	// of the assessmentRunName property of the AssessmentRun data type.
	NamePattern *string `locationName:"namePattern" min:"1" type:"string"`

	// For a record to match a filter, the value that is specified for this data
	// type property must be contained in the list of values of the rulesPackages
	// property of the AssessmentRun data type.
	RulesPackageArns []string `locationName:"rulesPackageArns" type:"list"`

	// For a record to match a filter, the value that is specified for this data
	// type property must inclusively match any value between the specified minimum
	// and maximum values of the startTime property of the AssessmentRun data type.
	StartTimeRange *TimestampRange `locationName:"startTimeRange" type:"structure"`

	// For a record to match a filter, the value that is specified for this data
	// type property must match the stateChangedAt property of the AssessmentRun
	// data type.
	StateChangeTimeRange *TimestampRange `locationName:"stateChangeTimeRange" type:"structure"`

	// For a record to match a filter, one of the values specified for this data
	// type property must be the exact match of the value of the assessmentRunState
	// property of the AssessmentRun data type.
	States []AssessmentRunState `locationName:"states" type:"list"`
}

// String returns the string representation
func (s AssessmentRunFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssessmentRunFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssessmentRunFilter"}
	if s.NamePattern != nil && len(*s.NamePattern) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NamePattern", 1))
	}
	if s.DurationRange != nil {
		if err := s.DurationRange.Validate(); err != nil {
			invalidParams.AddNested("DurationRange", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Used as one of the elements of the AssessmentRun data type.
type AssessmentRunNotification struct {
	_ struct{} `type:"structure"`

	// The date of the notification.
	//
	// Date is a required field
	Date *time.Time `locationName:"date" type:"timestamp" required:"true"`

	// The Boolean value that specifies whether the notification represents an error.
	//
	// Error is a required field
	Error *bool `locationName:"error" type:"boolean" required:"true"`

	// The event for which a notification is sent.
	//
	// Event is a required field
	Event InspectorEvent `locationName:"event" type:"string" required:"true" enum:"true"`

	// The message included in the notification.
	Message *string `locationName:"message" type:"string"`

	// The status code of the SNS notification.
	SnsPublishStatusCode AssessmentRunNotificationSnsStatusCode `locationName:"snsPublishStatusCode" type:"string" enum:"true"`

	// The SNS topic to which the SNS notification is sent.
	SnsTopicArn *string `locationName:"snsTopicArn" min:"1" type:"string"`
}

// String returns the string representation
func (s AssessmentRunNotification) String() string {
	return awsutil.Prettify(s)
}

// Used as one of the elements of the AssessmentRun data type.
type AssessmentRunStateChange struct {
	_ struct{} `type:"structure"`

	// The assessment run state.
	//
	// State is a required field
	State AssessmentRunState `locationName:"state" type:"string" required:"true" enum:"true"`

	// The last time the assessment run state changed.
	//
	// StateChangedAt is a required field
	StateChangedAt *time.Time `locationName:"stateChangedAt" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s AssessmentRunStateChange) String() string {
	return awsutil.Prettify(s)
}

// Contains information about an Amazon Inspector application. This data type
// is used as the response element in the DescribeAssessmentTargets action.
type AssessmentTarget struct {
	_ struct{} `type:"structure"`

	// The ARN that specifies the Amazon Inspector assessment target.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The time at which the assessment target is created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The name of the Amazon Inspector assessment target.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The ARN that specifies the resource group that is associated with the assessment
	// target.
	ResourceGroupArn *string `locationName:"resourceGroupArn" min:"1" type:"string"`

	// The time at which UpdateAssessmentTarget is called.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s AssessmentTarget) String() string {
	return awsutil.Prettify(s)
}

// Used as the request parameter in the ListAssessmentTargets action.
type AssessmentTargetFilter struct {
	_ struct{} `type:"structure"`

	// For a record to match a filter, an explicit value or a string that contains
	// a wildcard that is specified for this data type property must match the value
	// of the assessmentTargetName property of the AssessmentTarget data type.
	AssessmentTargetNamePattern *string `locationName:"assessmentTargetNamePattern" min:"1" type:"string"`
}

// String returns the string representation
func (s AssessmentTargetFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssessmentTargetFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssessmentTargetFilter"}
	if s.AssessmentTargetNamePattern != nil && len(*s.AssessmentTargetNamePattern) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AssessmentTargetNamePattern", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains information about an Amazon Inspector assessment template. This
// data type is used as the response element in the DescribeAssessmentTemplates
// action.
type AssessmentTemplate struct {
	_ struct{} `type:"structure"`

	// The ARN of the assessment template.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The number of existing assessment runs associated with this assessment template.
	// This value can be zero or a positive integer.
	//
	// AssessmentRunCount is a required field
	AssessmentRunCount *int64 `locationName:"assessmentRunCount" type:"integer" required:"true"`

	// The ARN of the assessment target that corresponds to this assessment template.
	//
	// AssessmentTargetArn is a required field
	AssessmentTargetArn *string `locationName:"assessmentTargetArn" min:"1" type:"string" required:"true"`

	// The time at which the assessment template is created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The duration in seconds specified for this assessment template. The default
	// value is 3600 seconds (one hour). The maximum value is 86400 seconds (one
	// day).
	//
	// DurationInSeconds is a required field
	DurationInSeconds *int64 `locationName:"durationInSeconds" min:"180" type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) of the most recent assessment run associated
	// with this assessment template. This value exists only when the value of assessmentRunCount
	// is greaterpa than zero.
	LastAssessmentRunArn *string `locationName:"lastAssessmentRunArn" min:"1" type:"string"`

	// The name of the assessment template.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The rules packages that are specified for this assessment template.
	//
	// RulesPackageArns is a required field
	RulesPackageArns []string `locationName:"rulesPackageArns" type:"list" required:"true"`

	// The user-defined attributes that are assigned to every generated finding
	// from the assessment run that uses this assessment template.
	//
	// UserAttributesForFindings is a required field
	UserAttributesForFindings []Attribute `locationName:"userAttributesForFindings" type:"list" required:"true"`
}

// String returns the string representation
func (s AssessmentTemplate) String() string {
	return awsutil.Prettify(s)
}

// Used as the request parameter in the ListAssessmentTemplates action.
type AssessmentTemplateFilter struct {
	_ struct{} `type:"structure"`

	// For a record to match a filter, the value specified for this data type property
	// must inclusively match any value between the specified minimum and maximum
	// values of the durationInSeconds property of the AssessmentTemplate data type.
	DurationRange *DurationRange `locationName:"durationRange" type:"structure"`

	// For a record to match a filter, an explicit value or a string that contains
	// a wildcard that is specified for this data type property must match the value
	// of the assessmentTemplateName property of the AssessmentTemplate data type.
	NamePattern *string `locationName:"namePattern" min:"1" type:"string"`

	// For a record to match a filter, the values that are specified for this data
	// type property must be contained in the list of values of the rulesPackageArns
	// property of the AssessmentTemplate data type.
	RulesPackageArns []string `locationName:"rulesPackageArns" type:"list"`
}

// String returns the string representation
func (s AssessmentTemplateFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssessmentTemplateFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssessmentTemplateFilter"}
	if s.NamePattern != nil && len(*s.NamePattern) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NamePattern", 1))
	}
	if s.DurationRange != nil {
		if err := s.DurationRange.Validate(); err != nil {
			invalidParams.AddNested("DurationRange", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A collection of attributes of the host from which the finding is generated.
type AssetAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the agent that is installed on the EC2 instance where the finding
	// is generated.
	AgentId *string `locationName:"agentId" min:"1" type:"string"`

	// The ID of the Amazon Machine Image (AMI) that is installed on the EC2 instance
	// where the finding is generated.
	AmiId *string `locationName:"amiId" type:"string"`

	// The Auto Scaling group of the EC2 instance where the finding is generated.
	AutoScalingGroup *string `locationName:"autoScalingGroup" min:"1" type:"string"`

	// The hostname of the EC2 instance where the finding is generated.
	Hostname *string `locationName:"hostname" type:"string"`

	// The list of IP v4 addresses of the EC2 instance where the finding is generated.
	Ipv4Addresses []string `locationName:"ipv4Addresses" type:"list"`

	// An array of the network interfaces interacting with the EC2 instance where
	// the finding is generated.
	NetworkInterfaces []NetworkInterface `locationName:"networkInterfaces" type:"list"`

	// The schema version of this data type.
	//
	// SchemaVersion is a required field
	SchemaVersion *int64 `locationName:"schemaVersion" type:"integer" required:"true"`

	// The tags related to the EC2 instance where the finding is generated.
	Tags []Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s AssetAttributes) String() string {
	return awsutil.Prettify(s)
}

// This data type is used as a request parameter in the AddAttributesToFindings
// and CreateAssessmentTemplate actions.
type Attribute struct {
	_ struct{} `type:"structure"`

	// The attribute key.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The value assigned to the attribute key.
	Value *string `locationName:"value" min:"1" type:"string"`
}

// String returns the string representation
func (s Attribute) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Attribute) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Attribute"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// This data type is used in the AssessmentTemplateFilter data type.
type DurationRange struct {
	_ struct{} `type:"structure"`

	// The maximum value of the duration range. Must be less than or equal to 604800
	// seconds (1 week).
	MaxSeconds *int64 `locationName:"maxSeconds" min:"180" type:"integer"`

	// The minimum value of the duration range. Must be greater than zero.
	MinSeconds *int64 `locationName:"minSeconds" min:"180" type:"integer"`
}

// String returns the string representation
func (s DurationRange) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DurationRange) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DurationRange"}
	if s.MaxSeconds != nil && *s.MaxSeconds < 180 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxSeconds", 180))
	}
	if s.MinSeconds != nil && *s.MinSeconds < 180 {
		invalidParams.Add(aws.NewErrParamMinValue("MinSeconds", 180))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// This data type is used in the Subscription data type.
type EventSubscription struct {
	_ struct{} `type:"structure"`

	// The event for which Amazon Simple Notification Service (SNS) notifications
	// are sent.
	//
	// Event is a required field
	Event InspectorEvent `locationName:"event" type:"string" required:"true" enum:"true"`

	// The time at which SubscribeToEvent is called.
	//
	// SubscribedAt is a required field
	SubscribedAt *time.Time `locationName:"subscribedAt" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s EventSubscription) String() string {
	return awsutil.Prettify(s)
}

// Contains information about what was excluded from an assessment run.
type Exclusion struct {
	_ struct{} `type:"structure"`

	// The ARN that specifies the exclusion.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The system-defined attributes for the exclusion.
	Attributes []Attribute `locationName:"attributes" type:"list"`

	// The description of the exclusion.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// The recommendation for the exclusion.
	//
	// Recommendation is a required field
	Recommendation *string `locationName:"recommendation" type:"string" required:"true"`

	// The AWS resources for which the exclusion pertains.
	//
	// Scopes is a required field
	Scopes []Scope `locationName:"scopes" min:"1" type:"list" required:"true"`

	// The name of the exclusion.
	//
	// Title is a required field
	Title *string `locationName:"title" type:"string" required:"true"`
}

// String returns the string representation
func (s Exclusion) String() string {
	return awsutil.Prettify(s)
}

// Contains information about what is excluded from an assessment run given
// the current state of the assessment template.
type ExclusionPreview struct {
	_ struct{} `type:"structure"`

	// The system-defined attributes for the exclusion preview.
	Attributes []Attribute `locationName:"attributes" type:"list"`

	// The description of the exclusion preview.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// The recommendation for the exclusion preview.
	//
	// Recommendation is a required field
	Recommendation *string `locationName:"recommendation" type:"string" required:"true"`

	// The AWS resources for which the exclusion preview pertains.
	//
	// Scopes is a required field
	Scopes []Scope `locationName:"scopes" min:"1" type:"list" required:"true"`

	// The name of the exclusion preview.
	//
	// Title is a required field
	Title *string `locationName:"title" type:"string" required:"true"`
}

// String returns the string representation
func (s ExclusionPreview) String() string {
	return awsutil.Prettify(s)
}

// Includes details about the failed items.
type FailedItemDetails struct {
	_ struct{} `type:"structure"`

	// The status code of a failed item.
	//
	// FailureCode is a required field
	FailureCode FailedItemErrorCode `locationName:"failureCode" type:"string" required:"true" enum:"true"`

	// Indicates whether you can immediately retry a request for this item for a
	// specified resource.
	//
	// Retryable is a required field
	Retryable *bool `locationName:"retryable" type:"boolean" required:"true"`
}

// String returns the string representation
func (s FailedItemDetails) String() string {
	return awsutil.Prettify(s)
}

// Contains information about an Amazon Inspector finding. This data type is
// used as the response element in the DescribeFindings action.
type Finding struct {
	_ struct{} `type:"structure"`

	// The ARN that specifies the finding.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// A collection of attributes of the host from which the finding is generated.
	AssetAttributes *AssetAttributes `locationName:"assetAttributes" type:"structure"`

	// The type of the host from which the finding is generated.
	AssetType AssetType `locationName:"assetType" type:"string" enum:"true"`

	// The system-defined attributes for the finding.
	//
	// Attributes is a required field
	Attributes []Attribute `locationName:"attributes" type:"list" required:"true"`

	// This data element is currently not used.
	Confidence *int64 `locationName:"confidence" type:"integer"`

	// The time when the finding was generated.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The description of the finding.
	Description *string `locationName:"description" type:"string"`

	// The ID of the finding.
	Id *string `locationName:"id" type:"string"`

	// This data element is currently not used.
	IndicatorOfCompromise *bool `locationName:"indicatorOfCompromise" type:"boolean"`

	// The numeric value of the finding severity.
	NumericSeverity *float64 `locationName:"numericSeverity" type:"double"`

	// The recommendation for the finding.
	Recommendation *string `locationName:"recommendation" type:"string"`

	// The schema version of this data type.
	SchemaVersion *int64 `locationName:"schemaVersion" type:"integer"`

	// The data element is set to "Inspector".
	Service *string `locationName:"service" type:"string"`

	// This data type is used in the Finding data type.
	ServiceAttributes *InspectorServiceAttributes `locationName:"serviceAttributes" type:"structure"`

	// The finding severity. Values can be set to High, Medium, Low, and Informational.
	Severity Severity `locationName:"severity" type:"string" enum:"true"`

	// The name of the finding.
	Title *string `locationName:"title" type:"string"`

	// The time when AddAttributesToFindings is called.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`

	// The user-defined attributes that are assigned to the finding.
	//
	// UserAttributes is a required field
	UserAttributes []Attribute `locationName:"userAttributes" type:"list" required:"true"`
}

// String returns the string representation
func (s Finding) String() string {
	return awsutil.Prettify(s)
}

// This data type is used as a request parameter in the ListFindings action.
type FindingFilter struct {
	_ struct{} `type:"structure"`

	// For a record to match a filter, one of the values that is specified for this
	// data type property must be the exact match of the value of the agentId property
	// of the Finding data type.
	AgentIds []string `locationName:"agentIds" type:"list"`

	// For a record to match a filter, the list of values that are specified for
	// this data type property must be contained in the list of values of the attributes
	// property of the Finding data type.
	Attributes []Attribute `locationName:"attributes" type:"list"`

	// For a record to match a filter, one of the values that is specified for this
	// data type property must be the exact match of the value of the autoScalingGroup
	// property of the Finding data type.
	AutoScalingGroups []string `locationName:"autoScalingGroups" type:"list"`

	// The time range during which the finding is generated.
	CreationTimeRange *TimestampRange `locationName:"creationTimeRange" type:"structure"`

	// For a record to match a filter, one of the values that is specified for this
	// data type property must be the exact match of the value of the ruleName property
	// of the Finding data type.
	RuleNames []string `locationName:"ruleNames" type:"list"`

	// For a record to match a filter, one of the values that is specified for this
	// data type property must be the exact match of the value of the rulesPackageArn
	// property of the Finding data type.
	RulesPackageArns []string `locationName:"rulesPackageArns" type:"list"`

	// For a record to match a filter, one of the values that is specified for this
	// data type property must be the exact match of the value of the severity property
	// of the Finding data type.
	Severities []Severity `locationName:"severities" type:"list"`

	// For a record to match a filter, the value that is specified for this data
	// type property must be contained in the list of values of the userAttributes
	// property of the Finding data type.
	UserAttributes []Attribute `locationName:"userAttributes" type:"list"`
}

// String returns the string representation
func (s FindingFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FindingFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FindingFilter"}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.UserAttributes != nil {
		for i, v := range s.UserAttributes {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UserAttributes", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// This data type is used in the Finding data type.
type InspectorServiceAttributes struct {
	_ struct{} `type:"structure"`

	// The ARN of the assessment run during which the finding is generated.
	AssessmentRunArn *string `locationName:"assessmentRunArn" min:"1" type:"string"`

	// The ARN of the rules package that is used to generate the finding.
	RulesPackageArn *string `locationName:"rulesPackageArn" min:"1" type:"string"`

	// The schema version of this data type.
	//
	// SchemaVersion is a required field
	SchemaVersion *int64 `locationName:"schemaVersion" type:"integer" required:"true"`
}

// String returns the string representation
func (s InspectorServiceAttributes) String() string {
	return awsutil.Prettify(s)
}

// Contains information about the network interfaces interacting with an EC2
// instance. This data type is used as one of the elements of the AssetAttributes
// data type.
type NetworkInterface struct {
	_ struct{} `type:"structure"`

	// The IP addresses associated with the network interface.
	Ipv6Addresses []string `locationName:"ipv6Addresses" type:"list"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`

	// The name of a private DNS associated with the network interface.
	PrivateDnsName *string `locationName:"privateDnsName" type:"string"`

	// The private IP address associated with the network interface.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// A list of the private IP addresses associated with the network interface.
	// Includes the privateDnsName and privateIpAddress.
	PrivateIpAddresses []PrivateIp `locationName:"privateIpAddresses" type:"list"`

	// The name of a public DNS associated with the network interface.
	PublicDnsName *string `locationName:"publicDnsName" type:"string"`

	// The public IP address from which the network interface is reachable.
	PublicIp *string `locationName:"publicIp" type:"string"`

	// A list of the security groups associated with the network interface. Includes
	// the groupId and groupName.
	SecurityGroups []SecurityGroup `locationName:"securityGroups" type:"list"`

	// The ID of a subnet associated with the network interface.
	SubnetId *string `locationName:"subnetId" type:"string"`

	// The ID of a VPC associated with the network interface.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s NetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// Contains information about a private IP address associated with a network
// interface. This data type is used as a response element in the DescribeFindings
// action.
type PrivateIp struct {
	_ struct{} `type:"structure"`

	// The DNS name of the private IP address.
	PrivateDnsName *string `locationName:"privateDnsName" type:"string"`

	// The full IP address of the network inteface.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`
}

// String returns the string representation
func (s PrivateIp) String() string {
	return awsutil.Prettify(s)
}

// Contains information about a resource group. The resource group defines a
// set of tags that, when queried, identify the AWS resources that make up the
// assessment target. This data type is used as the response element in the
// DescribeResourceGroups action.
type ResourceGroup struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource group.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The time at which resource group is created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The tags (key and value pairs) of the resource group. This data type property
	// is used in the CreateResourceGroup action.
	//
	// Tags is a required field
	Tags []ResourceGroupTag `locationName:"tags" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s ResourceGroup) String() string {
	return awsutil.Prettify(s)
}

// This data type is used as one of the elements of the ResourceGroup data type.
type ResourceGroupTag struct {
	_ struct{} `type:"structure"`

	// A tag key.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The value assigned to a tag key.
	Value *string `locationName:"value" min:"1" type:"string"`
}

// String returns the string representation
func (s ResourceGroupTag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceGroupTag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResourceGroupTag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains information about an Amazon Inspector rules package. This data type
// is used as the response element in the DescribeRulesPackages action.
type RulesPackage struct {
	_ struct{} `type:"structure"`

	// The ARN of the rules package.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The description of the rules package.
	Description *string `locationName:"description" type:"string"`

	// The name of the rules package.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The provider of the rules package.
	//
	// Provider is a required field
	Provider *string `locationName:"provider" type:"string" required:"true"`

	// The version ID of the rules package.
	//
	// Version is a required field
	Version *string `locationName:"version" type:"string" required:"true"`
}

// String returns the string representation
func (s RulesPackage) String() string {
	return awsutil.Prettify(s)
}

// This data type contains key-value pairs that identify various Amazon resources.
type Scope struct {
	_ struct{} `type:"structure"`

	// The type of the scope.
	Key ScopeType `locationName:"key" type:"string" enum:"true"`

	// The resource identifier for the specified scope type.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s Scope) String() string {
	return awsutil.Prettify(s)
}

// Contains information about a security group associated with a network interface.
// This data type is used as one of the elements of the NetworkInterface data
// type.
type SecurityGroup struct {
	_ struct{} `type:"structure"`

	// The ID of the security group.
	GroupId *string `locationName:"groupId" type:"string"`

	// The name of the security group.
	GroupName *string `locationName:"groupName" type:"string"`
}

// String returns the string representation
func (s SecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// This data type is used as a response element in the ListEventSubscriptions
// action.
type Subscription struct {
	_ struct{} `type:"structure"`

	// The list of existing event subscriptions.
	//
	// EventSubscriptions is a required field
	EventSubscriptions []EventSubscription `locationName:"eventSubscriptions" min:"1" type:"list" required:"true"`

	// The ARN of the assessment template that is used during the event for which
	// the SNS notification is sent.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The ARN of the Amazon Simple Notification Service (SNS) topic to which the
	// SNS notifications are sent.
	//
	// TopicArn is a required field
	TopicArn *string `locationName:"topicArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Subscription) String() string {
	return awsutil.Prettify(s)
}

// A key and value pair. This data type is used as a request parameter in the
// SetTagsForResource action and a response element in the ListTagsForResource
// action.
type Tag struct {
	_ struct{} `type:"structure"`

	// A tag key.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// A value assigned to a tag key.
	Value *string `locationName:"value" min:"1" type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The metadata about the Amazon Inspector application data metrics collected
// by the agent. This data type is used as the response element in the GetTelemetryMetadata
// action.
type TelemetryMetadata struct {
	_ struct{} `type:"structure"`

	// The count of messages that the agent sends to the Amazon Inspector service.
	//
	// Count is a required field
	Count *int64 `locationName:"count" type:"long" required:"true"`

	// The data size of messages that the agent sends to the Amazon Inspector service.
	DataSize *int64 `locationName:"dataSize" type:"long"`

	// A specific type of behavioral data that is collected by the agent.
	//
	// MessageType is a required field
	MessageType *string `locationName:"messageType" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TelemetryMetadata) String() string {
	return awsutil.Prettify(s)
}

// This data type is used in the AssessmentRunFilter data type.
type TimestampRange struct {
	_ struct{} `type:"structure"`

	// The minimum value of the timestamp range.
	BeginDate *time.Time `locationName:"beginDate" type:"timestamp"`

	// The maximum value of the timestamp range.
	EndDate *time.Time `locationName:"endDate" type:"timestamp"`
}

// String returns the string representation
func (s TimestampRange) String() string {
	return awsutil.Prettify(s)
}
