// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package inspector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeAssessmentRunsInput struct {
	_ struct{} `type:"structure"`

	// The ARN that specifies the assessment run that you want to describe.
	//
	// AssessmentRunArns is a required field
	AssessmentRunArns []string `locationName:"assessmentRunArns" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeAssessmentRunsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAssessmentRunsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAssessmentRunsInput"}

	if s.AssessmentRunArns == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssessmentRunArns"))
	}
	if s.AssessmentRunArns != nil && len(s.AssessmentRunArns) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AssessmentRunArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeAssessmentRunsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the assessment run.
	//
	// AssessmentRuns is a required field
	AssessmentRuns []AssessmentRun `locationName:"assessmentRuns" type:"list" required:"true"`

	// Assessment run details that cannot be described. An error code is provided
	// for each failed item.
	//
	// FailedItems is a required field
	FailedItems map[string]FailedItemDetails `locationName:"failedItems" type:"map" required:"true"`
}

// String returns the string representation
func (s DescribeAssessmentRunsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeAssessmentRuns = "DescribeAssessmentRuns"

// DescribeAssessmentRunsRequest returns a request value for making API operation for
// Amazon Inspector.
//
// Describes the assessment runs that are specified by the ARNs of the assessment
// runs.
//
//    // Example sending a request using DescribeAssessmentRunsRequest.
//    req := client.DescribeAssessmentRunsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeAssessmentRuns
func (c *Client) DescribeAssessmentRunsRequest(input *DescribeAssessmentRunsInput) DescribeAssessmentRunsRequest {
	op := &aws.Operation{
		Name:       opDescribeAssessmentRuns,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAssessmentRunsInput{}
	}

	req := c.newRequest(op, input, &DescribeAssessmentRunsOutput{})
	return DescribeAssessmentRunsRequest{Request: req, Input: input, Copy: c.DescribeAssessmentRunsRequest}
}

// DescribeAssessmentRunsRequest is the request type for the
// DescribeAssessmentRuns API operation.
type DescribeAssessmentRunsRequest struct {
	*aws.Request
	Input *DescribeAssessmentRunsInput
	Copy  func(*DescribeAssessmentRunsInput) DescribeAssessmentRunsRequest
}

// Send marshals and sends the DescribeAssessmentRuns API request.
func (r DescribeAssessmentRunsRequest) Send(ctx context.Context) (*DescribeAssessmentRunsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAssessmentRunsResponse{
		DescribeAssessmentRunsOutput: r.Request.Data.(*DescribeAssessmentRunsOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeAssessmentRunsResponse is the response type for the
// DescribeAssessmentRuns API operation.
type DescribeAssessmentRunsResponse struct {
	*DescribeAssessmentRunsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAssessmentRuns request.
func (r *DescribeAssessmentRunsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
