// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package imagebuilderiface provides an interface to enable mocking the EC2 Image Builder service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package imagebuilderiface

import (
	"github.com/aws/aws-sdk-go-v2/service/imagebuilder"
)

// ClientAPI provides an interface to enable mocking the
// imagebuilder.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // imagebuilder.
//    func myFunc(svc imagebuilderiface.ClientAPI) bool {
//        // Make svc.CancelImageCreation request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := imagebuilder.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        imagebuilderiface.ClientPI
//    }
//    func (m *mockClientClient) CancelImageCreation(input *imagebuilder.CancelImageCreationInput) (*imagebuilder.CancelImageCreationOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CancelImageCreationRequest(*imagebuilder.CancelImageCreationInput) imagebuilder.CancelImageCreationRequest

	CreateComponentRequest(*imagebuilder.CreateComponentInput) imagebuilder.CreateComponentRequest

	CreateDistributionConfigurationRequest(*imagebuilder.CreateDistributionConfigurationInput) imagebuilder.CreateDistributionConfigurationRequest

	CreateImageRequest(*imagebuilder.CreateImageInput) imagebuilder.CreateImageRequest

	CreateImagePipelineRequest(*imagebuilder.CreateImagePipelineInput) imagebuilder.CreateImagePipelineRequest

	CreateImageRecipeRequest(*imagebuilder.CreateImageRecipeInput) imagebuilder.CreateImageRecipeRequest

	CreateInfrastructureConfigurationRequest(*imagebuilder.CreateInfrastructureConfigurationInput) imagebuilder.CreateInfrastructureConfigurationRequest

	DeleteComponentRequest(*imagebuilder.DeleteComponentInput) imagebuilder.DeleteComponentRequest

	DeleteDistributionConfigurationRequest(*imagebuilder.DeleteDistributionConfigurationInput) imagebuilder.DeleteDistributionConfigurationRequest

	DeleteImageRequest(*imagebuilder.DeleteImageInput) imagebuilder.DeleteImageRequest

	DeleteImagePipelineRequest(*imagebuilder.DeleteImagePipelineInput) imagebuilder.DeleteImagePipelineRequest

	DeleteImageRecipeRequest(*imagebuilder.DeleteImageRecipeInput) imagebuilder.DeleteImageRecipeRequest

	DeleteInfrastructureConfigurationRequest(*imagebuilder.DeleteInfrastructureConfigurationInput) imagebuilder.DeleteInfrastructureConfigurationRequest

	GetComponentRequest(*imagebuilder.GetComponentInput) imagebuilder.GetComponentRequest

	GetComponentPolicyRequest(*imagebuilder.GetComponentPolicyInput) imagebuilder.GetComponentPolicyRequest

	GetDistributionConfigurationRequest(*imagebuilder.GetDistributionConfigurationInput) imagebuilder.GetDistributionConfigurationRequest

	GetImageRequest(*imagebuilder.GetImageInput) imagebuilder.GetImageRequest

	GetImagePipelineRequest(*imagebuilder.GetImagePipelineInput) imagebuilder.GetImagePipelineRequest

	GetImagePolicyRequest(*imagebuilder.GetImagePolicyInput) imagebuilder.GetImagePolicyRequest

	GetImageRecipeRequest(*imagebuilder.GetImageRecipeInput) imagebuilder.GetImageRecipeRequest

	GetImageRecipePolicyRequest(*imagebuilder.GetImageRecipePolicyInput) imagebuilder.GetImageRecipePolicyRequest

	GetInfrastructureConfigurationRequest(*imagebuilder.GetInfrastructureConfigurationInput) imagebuilder.GetInfrastructureConfigurationRequest

	ImportComponentRequest(*imagebuilder.ImportComponentInput) imagebuilder.ImportComponentRequest

	ListComponentBuildVersionsRequest(*imagebuilder.ListComponentBuildVersionsInput) imagebuilder.ListComponentBuildVersionsRequest

	ListComponentsRequest(*imagebuilder.ListComponentsInput) imagebuilder.ListComponentsRequest

	ListDistributionConfigurationsRequest(*imagebuilder.ListDistributionConfigurationsInput) imagebuilder.ListDistributionConfigurationsRequest

	ListImageBuildVersionsRequest(*imagebuilder.ListImageBuildVersionsInput) imagebuilder.ListImageBuildVersionsRequest

	ListImagePipelineImagesRequest(*imagebuilder.ListImagePipelineImagesInput) imagebuilder.ListImagePipelineImagesRequest

	ListImagePipelinesRequest(*imagebuilder.ListImagePipelinesInput) imagebuilder.ListImagePipelinesRequest

	ListImageRecipesRequest(*imagebuilder.ListImageRecipesInput) imagebuilder.ListImageRecipesRequest

	ListImagesRequest(*imagebuilder.ListImagesInput) imagebuilder.ListImagesRequest

	ListInfrastructureConfigurationsRequest(*imagebuilder.ListInfrastructureConfigurationsInput) imagebuilder.ListInfrastructureConfigurationsRequest

	ListTagsForResourceRequest(*imagebuilder.ListTagsForResourceInput) imagebuilder.ListTagsForResourceRequest

	PutComponentPolicyRequest(*imagebuilder.PutComponentPolicyInput) imagebuilder.PutComponentPolicyRequest

	PutImagePolicyRequest(*imagebuilder.PutImagePolicyInput) imagebuilder.PutImagePolicyRequest

	PutImageRecipePolicyRequest(*imagebuilder.PutImageRecipePolicyInput) imagebuilder.PutImageRecipePolicyRequest

	StartImagePipelineExecutionRequest(*imagebuilder.StartImagePipelineExecutionInput) imagebuilder.StartImagePipelineExecutionRequest

	TagResourceRequest(*imagebuilder.TagResourceInput) imagebuilder.TagResourceRequest

	UntagResourceRequest(*imagebuilder.UntagResourceInput) imagebuilder.UntagResourceRequest

	UpdateDistributionConfigurationRequest(*imagebuilder.UpdateDistributionConfigurationInput) imagebuilder.UpdateDistributionConfigurationRequest

	UpdateImagePipelineRequest(*imagebuilder.UpdateImagePipelineInput) imagebuilder.UpdateImagePipelineRequest

	UpdateInfrastructureConfigurationRequest(*imagebuilder.UpdateInfrastructureConfigurationInput) imagebuilder.UpdateInfrastructureConfigurationRequest
}

var _ ClientAPI = (*imagebuilder.Client)(nil)
