// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package greengrassiface provides an interface to enable mocking the AWS Greengrass service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package greengrassiface

import (
	"github.com/aws/aws-sdk-go-v2/service/greengrass"
)

// ClientAPI provides an interface to enable mocking the
// greengrass.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS Greengrass.
//    func myFunc(svc greengrassiface.ClientAPI) bool {
//        // Make svc.AssociateRoleToGroup request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := greengrass.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        greengrassiface.ClientPI
//    }
//    func (m *mockClientClient) AssociateRoleToGroup(input *greengrass.AssociateRoleToGroupInput) (*greengrass.AssociateRoleToGroupOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AssociateRoleToGroupRequest(*greengrass.AssociateRoleToGroupInput) greengrass.AssociateRoleToGroupRequest

	AssociateServiceRoleToAccountRequest(*greengrass.AssociateServiceRoleToAccountInput) greengrass.AssociateServiceRoleToAccountRequest

	CreateConnectorDefinitionRequest(*greengrass.CreateConnectorDefinitionInput) greengrass.CreateConnectorDefinitionRequest

	CreateConnectorDefinitionVersionRequest(*greengrass.CreateConnectorDefinitionVersionInput) greengrass.CreateConnectorDefinitionVersionRequest

	CreateCoreDefinitionRequest(*greengrass.CreateCoreDefinitionInput) greengrass.CreateCoreDefinitionRequest

	CreateCoreDefinitionVersionRequest(*greengrass.CreateCoreDefinitionVersionInput) greengrass.CreateCoreDefinitionVersionRequest

	CreateDeploymentRequest(*greengrass.CreateDeploymentInput) greengrass.CreateDeploymentRequest

	CreateDeviceDefinitionRequest(*greengrass.CreateDeviceDefinitionInput) greengrass.CreateDeviceDefinitionRequest

	CreateDeviceDefinitionVersionRequest(*greengrass.CreateDeviceDefinitionVersionInput) greengrass.CreateDeviceDefinitionVersionRequest

	CreateFunctionDefinitionRequest(*greengrass.CreateFunctionDefinitionInput) greengrass.CreateFunctionDefinitionRequest

	CreateFunctionDefinitionVersionRequest(*greengrass.CreateFunctionDefinitionVersionInput) greengrass.CreateFunctionDefinitionVersionRequest

	CreateGroupRequest(*greengrass.CreateGroupInput) greengrass.CreateGroupRequest

	CreateGroupCertificateAuthorityRequest(*greengrass.CreateGroupCertificateAuthorityInput) greengrass.CreateGroupCertificateAuthorityRequest

	CreateGroupVersionRequest(*greengrass.CreateGroupVersionInput) greengrass.CreateGroupVersionRequest

	CreateLoggerDefinitionRequest(*greengrass.CreateLoggerDefinitionInput) greengrass.CreateLoggerDefinitionRequest

	CreateLoggerDefinitionVersionRequest(*greengrass.CreateLoggerDefinitionVersionInput) greengrass.CreateLoggerDefinitionVersionRequest

	CreateResourceDefinitionRequest(*greengrass.CreateResourceDefinitionInput) greengrass.CreateResourceDefinitionRequest

	CreateResourceDefinitionVersionRequest(*greengrass.CreateResourceDefinitionVersionInput) greengrass.CreateResourceDefinitionVersionRequest

	CreateSoftwareUpdateJobRequest(*greengrass.CreateSoftwareUpdateJobInput) greengrass.CreateSoftwareUpdateJobRequest

	CreateSubscriptionDefinitionRequest(*greengrass.CreateSubscriptionDefinitionInput) greengrass.CreateSubscriptionDefinitionRequest

	CreateSubscriptionDefinitionVersionRequest(*greengrass.CreateSubscriptionDefinitionVersionInput) greengrass.CreateSubscriptionDefinitionVersionRequest

	DeleteConnectorDefinitionRequest(*greengrass.DeleteConnectorDefinitionInput) greengrass.DeleteConnectorDefinitionRequest

	DeleteCoreDefinitionRequest(*greengrass.DeleteCoreDefinitionInput) greengrass.DeleteCoreDefinitionRequest

	DeleteDeviceDefinitionRequest(*greengrass.DeleteDeviceDefinitionInput) greengrass.DeleteDeviceDefinitionRequest

	DeleteFunctionDefinitionRequest(*greengrass.DeleteFunctionDefinitionInput) greengrass.DeleteFunctionDefinitionRequest

	DeleteGroupRequest(*greengrass.DeleteGroupInput) greengrass.DeleteGroupRequest

	DeleteLoggerDefinitionRequest(*greengrass.DeleteLoggerDefinitionInput) greengrass.DeleteLoggerDefinitionRequest

	DeleteResourceDefinitionRequest(*greengrass.DeleteResourceDefinitionInput) greengrass.DeleteResourceDefinitionRequest

	DeleteSubscriptionDefinitionRequest(*greengrass.DeleteSubscriptionDefinitionInput) greengrass.DeleteSubscriptionDefinitionRequest

	DisassociateRoleFromGroupRequest(*greengrass.DisassociateRoleFromGroupInput) greengrass.DisassociateRoleFromGroupRequest

	DisassociateServiceRoleFromAccountRequest(*greengrass.DisassociateServiceRoleFromAccountInput) greengrass.DisassociateServiceRoleFromAccountRequest

	GetAssociatedRoleRequest(*greengrass.GetAssociatedRoleInput) greengrass.GetAssociatedRoleRequest

	GetBulkDeploymentStatusRequest(*greengrass.GetBulkDeploymentStatusInput) greengrass.GetBulkDeploymentStatusRequest

	GetConnectivityInfoRequest(*greengrass.GetConnectivityInfoInput) greengrass.GetConnectivityInfoRequest

	GetConnectorDefinitionRequest(*greengrass.GetConnectorDefinitionInput) greengrass.GetConnectorDefinitionRequest

	GetConnectorDefinitionVersionRequest(*greengrass.GetConnectorDefinitionVersionInput) greengrass.GetConnectorDefinitionVersionRequest

	GetCoreDefinitionRequest(*greengrass.GetCoreDefinitionInput) greengrass.GetCoreDefinitionRequest

	GetCoreDefinitionVersionRequest(*greengrass.GetCoreDefinitionVersionInput) greengrass.GetCoreDefinitionVersionRequest

	GetDeploymentStatusRequest(*greengrass.GetDeploymentStatusInput) greengrass.GetDeploymentStatusRequest

	GetDeviceDefinitionRequest(*greengrass.GetDeviceDefinitionInput) greengrass.GetDeviceDefinitionRequest

	GetDeviceDefinitionVersionRequest(*greengrass.GetDeviceDefinitionVersionInput) greengrass.GetDeviceDefinitionVersionRequest

	GetFunctionDefinitionRequest(*greengrass.GetFunctionDefinitionInput) greengrass.GetFunctionDefinitionRequest

	GetFunctionDefinitionVersionRequest(*greengrass.GetFunctionDefinitionVersionInput) greengrass.GetFunctionDefinitionVersionRequest

	GetGroupRequest(*greengrass.GetGroupInput) greengrass.GetGroupRequest

	GetGroupCertificateAuthorityRequest(*greengrass.GetGroupCertificateAuthorityInput) greengrass.GetGroupCertificateAuthorityRequest

	GetGroupCertificateConfigurationRequest(*greengrass.GetGroupCertificateConfigurationInput) greengrass.GetGroupCertificateConfigurationRequest

	GetGroupVersionRequest(*greengrass.GetGroupVersionInput) greengrass.GetGroupVersionRequest

	GetLoggerDefinitionRequest(*greengrass.GetLoggerDefinitionInput) greengrass.GetLoggerDefinitionRequest

	GetLoggerDefinitionVersionRequest(*greengrass.GetLoggerDefinitionVersionInput) greengrass.GetLoggerDefinitionVersionRequest

	GetResourceDefinitionRequest(*greengrass.GetResourceDefinitionInput) greengrass.GetResourceDefinitionRequest

	GetResourceDefinitionVersionRequest(*greengrass.GetResourceDefinitionVersionInput) greengrass.GetResourceDefinitionVersionRequest

	GetServiceRoleForAccountRequest(*greengrass.GetServiceRoleForAccountInput) greengrass.GetServiceRoleForAccountRequest

	GetSubscriptionDefinitionRequest(*greengrass.GetSubscriptionDefinitionInput) greengrass.GetSubscriptionDefinitionRequest

	GetSubscriptionDefinitionVersionRequest(*greengrass.GetSubscriptionDefinitionVersionInput) greengrass.GetSubscriptionDefinitionVersionRequest

	ListBulkDeploymentDetailedReportsRequest(*greengrass.ListBulkDeploymentDetailedReportsInput) greengrass.ListBulkDeploymentDetailedReportsRequest

	ListBulkDeploymentsRequest(*greengrass.ListBulkDeploymentsInput) greengrass.ListBulkDeploymentsRequest

	ListConnectorDefinitionVersionsRequest(*greengrass.ListConnectorDefinitionVersionsInput) greengrass.ListConnectorDefinitionVersionsRequest

	ListConnectorDefinitionsRequest(*greengrass.ListConnectorDefinitionsInput) greengrass.ListConnectorDefinitionsRequest

	ListCoreDefinitionVersionsRequest(*greengrass.ListCoreDefinitionVersionsInput) greengrass.ListCoreDefinitionVersionsRequest

	ListCoreDefinitionsRequest(*greengrass.ListCoreDefinitionsInput) greengrass.ListCoreDefinitionsRequest

	ListDeploymentsRequest(*greengrass.ListDeploymentsInput) greengrass.ListDeploymentsRequest

	ListDeviceDefinitionVersionsRequest(*greengrass.ListDeviceDefinitionVersionsInput) greengrass.ListDeviceDefinitionVersionsRequest

	ListDeviceDefinitionsRequest(*greengrass.ListDeviceDefinitionsInput) greengrass.ListDeviceDefinitionsRequest

	ListFunctionDefinitionVersionsRequest(*greengrass.ListFunctionDefinitionVersionsInput) greengrass.ListFunctionDefinitionVersionsRequest

	ListFunctionDefinitionsRequest(*greengrass.ListFunctionDefinitionsInput) greengrass.ListFunctionDefinitionsRequest

	ListGroupCertificateAuthoritiesRequest(*greengrass.ListGroupCertificateAuthoritiesInput) greengrass.ListGroupCertificateAuthoritiesRequest

	ListGroupVersionsRequest(*greengrass.ListGroupVersionsInput) greengrass.ListGroupVersionsRequest

	ListGroupsRequest(*greengrass.ListGroupsInput) greengrass.ListGroupsRequest

	ListLoggerDefinitionVersionsRequest(*greengrass.ListLoggerDefinitionVersionsInput) greengrass.ListLoggerDefinitionVersionsRequest

	ListLoggerDefinitionsRequest(*greengrass.ListLoggerDefinitionsInput) greengrass.ListLoggerDefinitionsRequest

	ListResourceDefinitionVersionsRequest(*greengrass.ListResourceDefinitionVersionsInput) greengrass.ListResourceDefinitionVersionsRequest

	ListResourceDefinitionsRequest(*greengrass.ListResourceDefinitionsInput) greengrass.ListResourceDefinitionsRequest

	ListSubscriptionDefinitionVersionsRequest(*greengrass.ListSubscriptionDefinitionVersionsInput) greengrass.ListSubscriptionDefinitionVersionsRequest

	ListSubscriptionDefinitionsRequest(*greengrass.ListSubscriptionDefinitionsInput) greengrass.ListSubscriptionDefinitionsRequest

	ListTagsForResourceRequest(*greengrass.ListTagsForResourceInput) greengrass.ListTagsForResourceRequest

	ResetDeploymentsRequest(*greengrass.ResetDeploymentsInput) greengrass.ResetDeploymentsRequest

	StartBulkDeploymentRequest(*greengrass.StartBulkDeploymentInput) greengrass.StartBulkDeploymentRequest

	StopBulkDeploymentRequest(*greengrass.StopBulkDeploymentInput) greengrass.StopBulkDeploymentRequest

	TagResourceRequest(*greengrass.TagResourceInput) greengrass.TagResourceRequest

	UntagResourceRequest(*greengrass.UntagResourceInput) greengrass.UntagResourceRequest

	UpdateConnectivityInfoRequest(*greengrass.UpdateConnectivityInfoInput) greengrass.UpdateConnectivityInfoRequest

	UpdateConnectorDefinitionRequest(*greengrass.UpdateConnectorDefinitionInput) greengrass.UpdateConnectorDefinitionRequest

	UpdateCoreDefinitionRequest(*greengrass.UpdateCoreDefinitionInput) greengrass.UpdateCoreDefinitionRequest

	UpdateDeviceDefinitionRequest(*greengrass.UpdateDeviceDefinitionInput) greengrass.UpdateDeviceDefinitionRequest

	UpdateFunctionDefinitionRequest(*greengrass.UpdateFunctionDefinitionInput) greengrass.UpdateFunctionDefinitionRequest

	UpdateGroupRequest(*greengrass.UpdateGroupInput) greengrass.UpdateGroupRequest

	UpdateGroupCertificateConfigurationRequest(*greengrass.UpdateGroupCertificateConfigurationInput) greengrass.UpdateGroupCertificateConfigurationRequest

	UpdateLoggerDefinitionRequest(*greengrass.UpdateLoggerDefinitionInput) greengrass.UpdateLoggerDefinitionRequest

	UpdateResourceDefinitionRequest(*greengrass.UpdateResourceDefinitionInput) greengrass.UpdateResourceDefinitionRequest

	UpdateSubscriptionDefinitionRequest(*greengrass.UpdateSubscriptionDefinitionInput) greengrass.UpdateSubscriptionDefinitionRequest
}

var _ ClientAPI = (*greengrass.Client)(nil)
