// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListWorkflowsInput struct {
	_ struct{} `type:"structure"`

	// The maximum size of a list to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is a continuation request.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListWorkflowsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkflowsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListWorkflowsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListWorkflowsOutput struct {
	_ struct{} `type:"structure"`

	// A continuation token, if not all workflow names have been returned.
	NextToken *string `type:"string"`

	// List of names of workflows in the account.
	Workflows []string `min:"1" type:"list"`
}

// String returns the string representation
func (s ListWorkflowsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListWorkflows = "ListWorkflows"

// ListWorkflowsRequest returns a request value for making API operation for
// AWS Glue.
//
// Lists names of workflows created in the account.
//
//    // Example sending a request using ListWorkflowsRequest.
//    req := client.ListWorkflowsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListWorkflows
func (c *Client) ListWorkflowsRequest(input *ListWorkflowsInput) ListWorkflowsRequest {
	op := &aws.Operation{
		Name:       opListWorkflows,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkflowsInput{}
	}

	req := c.newRequest(op, input, &ListWorkflowsOutput{})
	return ListWorkflowsRequest{Request: req, Input: input, Copy: c.ListWorkflowsRequest}
}

// ListWorkflowsRequest is the request type for the
// ListWorkflows API operation.
type ListWorkflowsRequest struct {
	*aws.Request
	Input *ListWorkflowsInput
	Copy  func(*ListWorkflowsInput) ListWorkflowsRequest
}

// Send marshals and sends the ListWorkflows API request.
func (r ListWorkflowsRequest) Send(ctx context.Context) (*ListWorkflowsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListWorkflowsResponse{
		ListWorkflowsOutput: r.Request.Data.(*ListWorkflowsOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListWorkflowsRequestPaginator returns a paginator for ListWorkflows.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListWorkflowsRequest(input)
//   p := glue.NewListWorkflowsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListWorkflowsPaginator(req ListWorkflowsRequest) ListWorkflowsPaginator {
	return ListWorkflowsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListWorkflowsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListWorkflowsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListWorkflowsPaginator struct {
	aws.Pager
}

func (p *ListWorkflowsPaginator) CurrentPage() *ListWorkflowsOutput {
	return p.Pager.CurrentPage().(*ListWorkflowsOutput)
}

// ListWorkflowsResponse is the response type for the
// ListWorkflows API operation.
type ListWorkflowsResponse struct {
	*ListWorkflowsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListWorkflows request.
func (r *ListWorkflowsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
