// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glacier

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Provides options to create a vault.
type CreateVaultInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID. This value must match the AWS
	// account ID associated with the credentials used to sign the request. You
	// can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you specify your account ID, do
	// not include any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateVaultInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVaultInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateVaultInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.VaultName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VaultName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateVaultInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VaultName != nil {
		v := *s.VaultName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "vaultName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains the Amazon S3 Glacier response to your request.
type CreateVaultOutput struct {
	_ struct{} `type:"structure"`

	// The URI of the vault that was created.
	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation
func (s CreateVaultOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateVaultOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Location != nil {
		v := *s.Location

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Location", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreateVault = "CreateVault"

// CreateVaultRequest returns a request value for making API operation for
// Amazon Glacier.
//
// This operation creates a new vault with the specified name. The name of the
// vault must be unique within a region for an AWS account. You can create up
// to 1,000 vaults per account. If you need to create more vaults, contact Amazon
// S3 Glacier.
//
// You must use the following guidelines when naming a vault.
//
//    * Names can be between 1 and 255 characters long.
//
//    * Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (hyphen),
//    and '.' (period).
//
// This operation is idempotent.
//
// An AWS account has full permission to perform all operations (actions). However,
// AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and underlying REST API, see Creating a Vault
// in Amazon Glacier (https://docs.aws.amazon.com/amazonglacier/latest/dev/creating-vaults.html)
// and Create Vault (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-put.html)
// in the Amazon Glacier Developer Guide.
//
//    // Example sending a request using CreateVaultRequest.
//    req := client.CreateVaultRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) CreateVaultRequest(input *CreateVaultInput) CreateVaultRequest {
	op := &aws.Operation{
		Name:       opCreateVault,
		HTTPMethod: "PUT",
		HTTPPath:   "/{accountId}/vaults/{vaultName}",
	}

	if input == nil {
		input = &CreateVaultInput{}
	}

	req := c.newRequest(op, input, &CreateVaultOutput{})
	return CreateVaultRequest{Request: req, Input: input, Copy: c.CreateVaultRequest}
}

// CreateVaultRequest is the request type for the
// CreateVault API operation.
type CreateVaultRequest struct {
	*aws.Request
	Input *CreateVaultInput
	Copy  func(*CreateVaultInput) CreateVaultRequest
}

// Send marshals and sends the CreateVault API request.
func (r CreateVaultRequest) Send(ctx context.Context) (*CreateVaultResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateVaultResponse{
		CreateVaultOutput: r.Request.Data.(*CreateVaultOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateVaultResponse is the response type for the
// CreateVault API operation.
type CreateVaultResponse struct {
	*CreateVaultOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateVault request.
func (r *CreateVaultResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
