// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input for a request action.
type CreatePlayerSessionInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the game session to add a player to.
	//
	// GameSessionId is a required field
	GameSessionId *string `min:"1" type:"string" required:"true"`

	// Developer-defined information related to a player. Amazon GameLift does not
	// use this data, so it can be formatted as needed for use in the game.
	PlayerData *string `min:"1" type:"string"`

	// Unique identifier for a player. Player IDs are developer-defined.
	//
	// PlayerId is a required field
	PlayerId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePlayerSessionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePlayerSessionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreatePlayerSessionInput"}

	if s.GameSessionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GameSessionId"))
	}
	if s.GameSessionId != nil && len(*s.GameSessionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GameSessionId", 1))
	}
	if s.PlayerData != nil && len(*s.PlayerData) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PlayerData", 1))
	}

	if s.PlayerId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PlayerId"))
	}
	if s.PlayerId != nil && len(*s.PlayerId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PlayerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the returned data in response to a request action.
type CreatePlayerSessionOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the newly created player session record.
	PlayerSession *PlayerSession `type:"structure"`
}

// String returns the string representation
func (s CreatePlayerSessionOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreatePlayerSession = "CreatePlayerSession"

// CreatePlayerSessionRequest returns a request value for making API operation for
// Amazon GameLift.
//
// Reserves an open player slot in an active game session. Before a player can
// be added, a game session must have an ACTIVE status, have a creation policy
// of ALLOW_ALL, and have an open player slot. To add a group of players to
// a game session, use CreatePlayerSessions. When the player connects to the
// game server and references a player session ID, the game server contacts
// the Amazon GameLift service to validate the player reservation and accept
// the player.
//
// To create a player session, specify a game session ID, player ID, and optionally
// a string of player data. If successful, a slot is reserved in the game session
// for the player and a new PlayerSession object is returned. Player sessions
// cannot be updated.
//
// Available in Amazon GameLift Local.
//
//    * CreatePlayerSession
//
//    * CreatePlayerSessions
//
//    * DescribePlayerSessions
//
//    * Game session placements StartGameSessionPlacement DescribeGameSessionPlacement
//    StopGameSessionPlacement
//
//    // Example sending a request using CreatePlayerSessionRequest.
//    req := client.CreatePlayerSessionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreatePlayerSession
func (c *Client) CreatePlayerSessionRequest(input *CreatePlayerSessionInput) CreatePlayerSessionRequest {
	op := &aws.Operation{
		Name:       opCreatePlayerSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePlayerSessionInput{}
	}

	req := c.newRequest(op, input, &CreatePlayerSessionOutput{})
	return CreatePlayerSessionRequest{Request: req, Input: input, Copy: c.CreatePlayerSessionRequest}
}

// CreatePlayerSessionRequest is the request type for the
// CreatePlayerSession API operation.
type CreatePlayerSessionRequest struct {
	*aws.Request
	Input *CreatePlayerSessionInput
	Copy  func(*CreatePlayerSessionInput) CreatePlayerSessionRequest
}

// Send marshals and sends the CreatePlayerSession API request.
func (r CreatePlayerSessionRequest) Send(ctx context.Context) (*CreatePlayerSessionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreatePlayerSessionResponse{
		CreatePlayerSessionOutput: r.Request.Data.(*CreatePlayerSessionOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreatePlayerSessionResponse is the response type for the
// CreatePlayerSession API operation.
type CreatePlayerSessionResponse struct {
	*CreatePlayerSessionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreatePlayerSession request.
func (r *CreatePlayerSessionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
