// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type PutModelInput struct {
	_ struct{} `type:"structure"`

	// The model description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The label schema.
	//
	// LabelSchema is a required field
	LabelSchema *LabelSchema `locationName:"labelSchema" type:"structure" required:"true"`

	// The model ID.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// The model type.
	//
	// ModelType is a required field
	ModelType ModelTypeEnum `locationName:"modelType" type:"string" required:"true" enum:"true"`

	// The model input variables.
	//
	// ModelVariables is a required field
	ModelVariables []ModelVariable `locationName:"modelVariables" type:"list" required:"true"`

	// The training data source location in Amazon S3.
	//
	// TrainingDataSource is a required field
	TrainingDataSource *TrainingDataSource `locationName:"trainingDataSource" type:"structure" required:"true"`
}

// String returns the string representation
func (s PutModelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutModelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutModelInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.LabelSchema == nil {
		invalidParams.Add(aws.NewErrParamRequired("LabelSchema"))
	}

	if s.ModelId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ModelId", 1))
	}
	if len(s.ModelType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ModelType"))
	}

	if s.ModelVariables == nil {
		invalidParams.Add(aws.NewErrParamRequired("ModelVariables"))
	}

	if s.TrainingDataSource == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrainingDataSource"))
	}
	if s.LabelSchema != nil {
		if err := s.LabelSchema.Validate(); err != nil {
			invalidParams.AddNested("LabelSchema", err.(aws.ErrInvalidParams))
		}
	}
	if s.ModelVariables != nil {
		for i, v := range s.ModelVariables {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ModelVariables", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.TrainingDataSource != nil {
		if err := s.TrainingDataSource.Validate(); err != nil {
			invalidParams.AddNested("TrainingDataSource", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutModelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutModelOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutModel = "PutModel"

// PutModelRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Creates or updates a model.
//
//    // Example sending a request using PutModelRequest.
//    req := client.PutModelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutModel
func (c *Client) PutModelRequest(input *PutModelInput) PutModelRequest {
	op := &aws.Operation{
		Name:       opPutModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutModelInput{}
	}

	req := c.newRequest(op, input, &PutModelOutput{})
	return PutModelRequest{Request: req, Input: input, Copy: c.PutModelRequest}
}

// PutModelRequest is the request type for the
// PutModel API operation.
type PutModelRequest struct {
	*aws.Request
	Input *PutModelInput
	Copy  func(*PutModelInput) PutModelRequest
}

// Send marshals and sends the PutModel API request.
func (r PutModelRequest) Send(ctx context.Context) (*PutModelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutModelResponse{
		PutModelOutput: r.Request.Data.(*PutModelOutput),
		response:       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutModelResponse is the response type for the
// PutModel API operation.
type PutModelResponse struct {
	*PutModelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutModel request.
func (r *PutModelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
