// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetVariablesInput struct {
	_ struct{} `type:"structure"`

	// The max size per page determined for the get variable request.
	MaxResults *int64 `locationName:"maxResults" min:"50" type:"integer"`

	// The name of the variable.
	Name *string `locationName:"name" type:"string"`

	// The next page token of the get variable request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetVariablesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVariablesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetVariablesInput"}
	if s.MaxResults != nil && *s.MaxResults < 50 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetVariablesOutput struct {
	_ struct{} `type:"structure"`

	// The next page token to be used in subsequent requests.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The names of the variables returned.
	Variables []Variable `locationName:"variables" type:"list"`
}

// String returns the string representation
func (s GetVariablesOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetVariables = "GetVariables"

// GetVariablesRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Gets all of the variables or the specific variable. This is a paginated API.
// Providing null maxSizePerPage results in retrieving maximum of 100 records
// per page. If you provide maxSizePerPage the value must be between 50 and
// 100. To get the next page result, a provide a pagination token from GetVariablesResult
// as part of your request. Null pagination token fetches the records from the
// beginning.
//
//    // Example sending a request using GetVariablesRequest.
//    req := client.GetVariablesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetVariables
func (c *Client) GetVariablesRequest(input *GetVariablesInput) GetVariablesRequest {
	op := &aws.Operation{
		Name:       opGetVariables,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetVariablesInput{}
	}

	req := c.newRequest(op, input, &GetVariablesOutput{})
	return GetVariablesRequest{Request: req, Input: input, Copy: c.GetVariablesRequest}
}

// GetVariablesRequest is the request type for the
// GetVariables API operation.
type GetVariablesRequest struct {
	*aws.Request
	Input *GetVariablesInput
	Copy  func(*GetVariablesInput) GetVariablesRequest
}

// Send marshals and sends the GetVariables API request.
func (r GetVariablesRequest) Send(ctx context.Context) (*GetVariablesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetVariablesResponse{
		GetVariablesOutput: r.Request.Data.(*GetVariablesOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetVariablesRequestPaginator returns a paginator for GetVariables.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetVariablesRequest(input)
//   p := frauddetector.NewGetVariablesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetVariablesPaginator(req GetVariablesRequest) GetVariablesPaginator {
	return GetVariablesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetVariablesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetVariablesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetVariablesPaginator struct {
	aws.Pager
}

func (p *GetVariablesPaginator) CurrentPage() *GetVariablesOutput {
	return p.Pager.CurrentPage().(*GetVariablesOutput)
}

// GetVariablesResponse is the response type for the
// GetVariables API operation.
type GetVariablesResponse struct {
	*GetVariablesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetVariables request.
func (r *GetVariablesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
