// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package forecast

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeleteForecastInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the forecast to delete.
	//
	// ForecastArn is a required field
	ForecastArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteForecastInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteForecastInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteForecastInput"}

	if s.ForecastArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ForecastArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteForecastOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteForecastOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteForecast = "DeleteForecast"

// DeleteForecastRequest returns a request value for making API operation for
// Amazon Forecast Service.
//
// Deletes a forecast created using the CreateForecast operation. You can delete
// only forecasts that have a status of ACTIVE or CREATE_FAILED. To get the
// status, use the DescribeForecast operation.
//
// You can't delete a forecast while it is being exported. After a forecast
// is deleted, you can no longer query the forecast.
//
//    // Example sending a request using DeleteForecastRequest.
//    req := client.DeleteForecastRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteForecast
func (c *Client) DeleteForecastRequest(input *DeleteForecastInput) DeleteForecastRequest {
	op := &aws.Operation{
		Name:       opDeleteForecast,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteForecastInput{}
	}

	req := c.newRequest(op, input, &DeleteForecastOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteForecastRequest{Request: req, Input: input, Copy: c.DeleteForecastRequest}
}

// DeleteForecastRequest is the request type for the
// DeleteForecast API operation.
type DeleteForecastRequest struct {
	*aws.Request
	Input *DeleteForecastInput
	Copy  func(*DeleteForecastInput) DeleteForecastRequest
}

// Send marshals and sends the DeleteForecast API request.
func (r DeleteForecastRequest) Send(ctx context.Context) (*DeleteForecastResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteForecastResponse{
		DeleteForecastOutput: r.Request.Data.(*DeleteForecastOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteForecastResponse is the response type for the
// DeleteForecast API operation.
type DeleteForecastResponse struct {
	*DeleteForecastOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteForecast request.
func (r *DeleteForecastResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
