// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package firehose

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UntagDeliveryStreamInput struct {
	_ struct{} `type:"structure"`

	// The name of the delivery stream.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`

	// A list of tag keys. Each corresponding tag is removed from the delivery stream.
	//
	// TagKeys is a required field
	TagKeys []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagDeliveryStreamInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagDeliveryStreamInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UntagDeliveryStreamInput"}

	if s.DeliveryStreamName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.DeliveryStreamName != nil && len(*s.DeliveryStreamName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DeliveryStreamName", 1))
	}

	if s.TagKeys == nil {
		invalidParams.Add(aws.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UntagDeliveryStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagDeliveryStreamOutput) String() string {
	return awsutil.Prettify(s)
}

const opUntagDeliveryStream = "UntagDeliveryStream"

// UntagDeliveryStreamRequest returns a request value for making API operation for
// Amazon Kinesis Firehose.
//
// Removes tags from the specified delivery stream. Removed tags are deleted,
// and you can't recover them after this operation successfully completes.
//
// If you specify a tag that doesn't exist, the operation ignores it.
//
// This operation has a limit of five transactions per second per account.
//
//    // Example sending a request using UntagDeliveryStreamRequest.
//    req := client.UntagDeliveryStreamRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/UntagDeliveryStream
func (c *Client) UntagDeliveryStreamRequest(input *UntagDeliveryStreamInput) UntagDeliveryStreamRequest {
	op := &aws.Operation{
		Name:       opUntagDeliveryStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagDeliveryStreamInput{}
	}

	req := c.newRequest(op, input, &UntagDeliveryStreamOutput{})
	return UntagDeliveryStreamRequest{Request: req, Input: input, Copy: c.UntagDeliveryStreamRequest}
}

// UntagDeliveryStreamRequest is the request type for the
// UntagDeliveryStream API operation.
type UntagDeliveryStreamRequest struct {
	*aws.Request
	Input *UntagDeliveryStreamInput
	Copy  func(*UntagDeliveryStreamInput) UntagDeliveryStreamRequest
}

// Send marshals and sends the UntagDeliveryStream API request.
func (r UntagDeliveryStreamRequest) Send(ctx context.Context) (*UntagDeliveryStreamResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UntagDeliveryStreamResponse{
		UntagDeliveryStreamOutput: r.Request.Data.(*UntagDeliveryStreamOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UntagDeliveryStreamResponse is the response type for the
// UntagDeliveryStream API operation.
type UntagDeliveryStreamResponse struct {
	*UntagDeliveryStreamOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UntagDeliveryStream request.
func (r *UntagDeliveryStreamResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
