// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticloadbalancing

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the parameters for DescribeInstanceHealth.
type DescribeInstanceHealthInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the instances.
	Instances []Instance `type:"list"`

	// The name of the load balancer.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeInstanceHealthInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInstanceHealthInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeInstanceHealthInput"}

	if s.LoadBalancerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LoadBalancerName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output for DescribeInstanceHealth.
type DescribeInstanceHealthOutput struct {
	_ struct{} `type:"structure"`

	// Information about the health of the instances.
	InstanceStates []InstanceState `type:"list"`
}

// String returns the string representation
func (s DescribeInstanceHealthOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeInstanceHealth = "DescribeInstanceHealth"

// DescribeInstanceHealthRequest returns a request value for making API operation for
// Elastic Load Balancing.
//
// Describes the state of the specified instances with respect to the specified
// load balancer. If no instances are specified, the call describes the state
// of all instances that are currently registered with the load balancer. If
// instances are specified, their state is returned even if they are no longer
// registered with the load balancer. The state of terminated instances is not
// returned.
//
//    // Example sending a request using DescribeInstanceHealthRequest.
//    req := client.DescribeInstanceHealthRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DescribeInstanceHealth
func (c *Client) DescribeInstanceHealthRequest(input *DescribeInstanceHealthInput) DescribeInstanceHealthRequest {
	op := &aws.Operation{
		Name:       opDescribeInstanceHealth,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstanceHealthInput{}
	}

	req := c.newRequest(op, input, &DescribeInstanceHealthOutput{})
	return DescribeInstanceHealthRequest{Request: req, Input: input, Copy: c.DescribeInstanceHealthRequest}
}

// DescribeInstanceHealthRequest is the request type for the
// DescribeInstanceHealth API operation.
type DescribeInstanceHealthRequest struct {
	*aws.Request
	Input *DescribeInstanceHealthInput
	Copy  func(*DescribeInstanceHealthInput) DescribeInstanceHealthRequest
}

// Send marshals and sends the DescribeInstanceHealth API request.
func (r DescribeInstanceHealthRequest) Send(ctx context.Context) (*DescribeInstanceHealthResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeInstanceHealthResponse{
		DescribeInstanceHealthOutput: r.Request.Data.(*DescribeInstanceHealthOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeInstanceHealthResponse is the response type for the
// DescribeInstanceHealth API operation.
type DescribeInstanceHealthResponse struct {
	*DescribeInstanceHealthOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeInstanceHealth request.
func (r *DescribeInstanceHealthResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
