// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticbeanstalk

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateApplicationVersionInput struct {
	_ struct{} `type:"structure"`

	// The name of the application. If no application is found with this name, and
	// AutoCreateApplication is false, returns an InvalidParameterValue error.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Set to true to create an application with the specified name if it doesn't
	// already exist.
	AutoCreateApplication *bool `type:"boolean"`

	// Settings for an AWS CodeBuild build.
	BuildConfiguration *BuildConfiguration `type:"structure"`

	// Describes this version.
	Description *string `type:"string"`

	// Pre-processes and validates the environment manifest (env.yaml) and configuration
	// files (*.config files in the .ebextensions folder) in the source bundle.
	// Validating configuration files can identify issues prior to deploying the
	// application version to an environment.
	//
	// You must turn processing on for application versions that you create using
	// AWS CodeBuild or AWS CodeCommit. For application versions built from a source
	// bundle in Amazon S3, processing is optional.
	//
	// The Process option validates Elastic Beanstalk configuration files. It doesn't
	// validate your application's configuration files, like proxy server or Docker
	// configuration.
	Process *bool `type:"boolean"`

	// Specify a commit in an AWS CodeCommit Git repository to use as the source
	// code for the application version.
	SourceBuildInformation *SourceBuildInformation `type:"structure"`

	// The Amazon S3 bucket and key that identify the location of the source bundle
	// for this version.
	//
	// The Amazon S3 bucket must be in the same region as the environment.
	//
	// Specify a source bundle in S3 or a commit in an AWS CodeCommit repository
	// (with SourceBuildInformation), but not both. If neither SourceBundle nor
	// SourceBuildInformation are provided, Elastic Beanstalk uses a sample application.
	SourceBundle *S3Location `type:"structure"`

	// Specifies the tags applied to the application version.
	//
	// Elastic Beanstalk applies these tags only to the application version. Environments
	// that use the application version don't inherit the tags.
	Tags []Tag `type:"list"`

	// A label identifying this version.
	//
	// Constraint: Must be unique per application. If an application version already
	// exists with this label for the specified application, AWS Elastic Beanstalk
	// returns an InvalidParameterValue error.
	//
	// VersionLabel is a required field
	VersionLabel *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateApplicationVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateApplicationVersionInput"}

	if s.ApplicationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationName", 1))
	}

	if s.VersionLabel == nil {
		invalidParams.Add(aws.NewErrParamRequired("VersionLabel"))
	}
	if s.VersionLabel != nil && len(*s.VersionLabel) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VersionLabel", 1))
	}
	if s.BuildConfiguration != nil {
		if err := s.BuildConfiguration.Validate(); err != nil {
			invalidParams.AddNested("BuildConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.SourceBuildInformation != nil {
		if err := s.SourceBuildInformation.Validate(); err != nil {
			invalidParams.AddNested("SourceBuildInformation", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Result message wrapping a single description of an application version.
type CreateApplicationVersionOutput struct {
	_ struct{} `type:"structure"`

	// The ApplicationVersionDescription of the application version.
	ApplicationVersion *ApplicationVersionDescription `type:"structure"`
}

// String returns the string representation
func (s CreateApplicationVersionOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateApplicationVersion = "CreateApplicationVersion"

// CreateApplicationVersionRequest returns a request value for making API operation for
// AWS Elastic Beanstalk.
//
// Creates an application version for the specified application. You can create
// an application version from a source bundle in Amazon S3, a commit in AWS
// CodeCommit, or the output of an AWS CodeBuild build as follows:
//
// Specify a commit in an AWS CodeCommit repository with SourceBuildInformation.
//
// Specify a build in an AWS CodeBuild with SourceBuildInformation and BuildConfiguration.
//
// Specify a source bundle in S3 with SourceBundle
//
// Omit both SourceBuildInformation and SourceBundle to use the default sample
// application.
//
// Once you create an application version with a specified Amazon S3 bucket
// and key location, you cannot change that Amazon S3 location. If you change
// the Amazon S3 location, you receive an exception when you attempt to launch
// an environment from the application version.
//
//    // Example sending a request using CreateApplicationVersionRequest.
//    req := client.CreateApplicationVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateApplicationVersion
func (c *Client) CreateApplicationVersionRequest(input *CreateApplicationVersionInput) CreateApplicationVersionRequest {
	op := &aws.Operation{
		Name:       opCreateApplicationVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateApplicationVersionInput{}
	}

	req := c.newRequest(op, input, &CreateApplicationVersionOutput{})
	return CreateApplicationVersionRequest{Request: req, Input: input, Copy: c.CreateApplicationVersionRequest}
}

// CreateApplicationVersionRequest is the request type for the
// CreateApplicationVersion API operation.
type CreateApplicationVersionRequest struct {
	*aws.Request
	Input *CreateApplicationVersionInput
	Copy  func(*CreateApplicationVersionInput) CreateApplicationVersionRequest
}

// Send marshals and sends the CreateApplicationVersion API request.
func (r CreateApplicationVersionRequest) Send(ctx context.Context) (*CreateApplicationVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateApplicationVersionResponse{
		CreateApplicationVersionOutput: r.Request.Data.(*CreateApplicationVersionOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateApplicationVersionResponse is the response type for the
// CreateApplicationVersion API operation.
type CreateApplicationVersionResponse struct {
	*CreateApplicationVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateApplicationVersion request.
func (r *CreateApplicationVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
