// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetDefaultCreditSpecificationInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The instance family.
	//
	// InstanceFamily is a required field
	InstanceFamily UnlimitedSupportedInstanceFamily `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s GetDefaultCreditSpecificationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDefaultCreditSpecificationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetDefaultCreditSpecificationInput"}
	if len(s.InstanceFamily) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("InstanceFamily"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetDefaultCreditSpecificationOutput struct {
	_ struct{} `type:"structure"`

	// The default credit option for CPU usage of the instance family.
	InstanceFamilyCreditSpecification *InstanceFamilyCreditSpecification `locationName:"instanceFamilyCreditSpecification" type:"structure"`
}

// String returns the string representation
func (s GetDefaultCreditSpecificationOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetDefaultCreditSpecification = "GetDefaultCreditSpecification"

// GetDefaultCreditSpecificationRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes the default credit option for CPU usage of a burstable performance
// instance family.
//
// For more information, see Burstable Performance Instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
//    // Example sending a request using GetDefaultCreditSpecificationRequest.
//    req := client.GetDefaultCreditSpecificationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/GetDefaultCreditSpecification
func (c *Client) GetDefaultCreditSpecificationRequest(input *GetDefaultCreditSpecificationInput) GetDefaultCreditSpecificationRequest {
	op := &aws.Operation{
		Name:       opGetDefaultCreditSpecification,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDefaultCreditSpecificationInput{}
	}

	req := c.newRequest(op, input, &GetDefaultCreditSpecificationOutput{})
	return GetDefaultCreditSpecificationRequest{Request: req, Input: input, Copy: c.GetDefaultCreditSpecificationRequest}
}

// GetDefaultCreditSpecificationRequest is the request type for the
// GetDefaultCreditSpecification API operation.
type GetDefaultCreditSpecificationRequest struct {
	*aws.Request
	Input *GetDefaultCreditSpecificationInput
	Copy  func(*GetDefaultCreditSpecificationInput) GetDefaultCreditSpecificationRequest
}

// Send marshals and sends the GetDefaultCreditSpecification API request.
func (r GetDefaultCreditSpecificationRequest) Send(ctx context.Context) (*GetDefaultCreditSpecificationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetDefaultCreditSpecificationResponse{
		GetDefaultCreditSpecificationOutput: r.Request.Data.(*GetDefaultCreditSpecificationOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetDefaultCreditSpecificationResponse is the response type for the
// GetDefaultCreditSpecification API operation.
type GetDefaultCreditSpecificationResponse struct {
	*GetDefaultCreditSpecificationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetDefaultCreditSpecification request.
func (r *GetDefaultCreditSpecificationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
