// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the parameters for DescribeVpnGateways.
type DescribeVpnGatewaysInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// One or more filters.
	//
	//    * amazon-side-asn - The Autonomous System Number (ASN) for the Amazon
	//    side of the gateway.
	//
	//    * attachment.state - The current state of the attachment between the gateway
	//    and the VPC (attaching | attached | detaching | detached).
	//
	//    * attachment.vpc-id - The ID of an attached VPC.
	//
	//    * availability-zone - The Availability Zone for the virtual private gateway
	//    (if applicable).
	//
	//    * state - The state of the virtual private gateway (pending | available
	//    | deleting | deleted).
	//
	//    * tag:<key> - The key/value combination of a tag assigned to the resource.
	//    Use the tag key in the filter name and the tag value as the filter value.
	//    For example, to find all resources that have a tag with the key Owner
	//    and the value TeamA, specify tag:Owner for the filter name and TeamA for
	//    the filter value.
	//
	//    * tag-key - The key of a tag assigned to the resource. Use this filter
	//    to find all resources assigned a tag with a specific key, regardless of
	//    the tag value.
	//
	//    * type - The type of virtual private gateway. Currently the only supported
	//    type is ipsec.1.
	//
	//    * vpn-gateway-id - The ID of the virtual private gateway.
	Filters []Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// One or more virtual private gateway IDs.
	//
	// Default: Describes all your virtual private gateways.
	VpnGatewayIds []string `locationName:"VpnGatewayId" locationNameList:"VpnGatewayId" type:"list"`
}

// String returns the string representation
func (s DescribeVpnGatewaysInput) String() string {
	return awsutil.Prettify(s)
}

// Contains the output of DescribeVpnGateways.
type DescribeVpnGatewaysOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more virtual private gateways.
	VpnGateways []VpnGateway `locationName:"vpnGatewaySet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeVpnGatewaysOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeVpnGateways = "DescribeVpnGateways"

// DescribeVpnGatewaysRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes one or more of your virtual private gateways.
//
// For more information, see AWS Site-to-Site VPN (https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html)
// in the AWS Site-to-Site VPN User Guide.
//
//    // Example sending a request using DescribeVpnGatewaysRequest.
//    req := client.DescribeVpnGatewaysRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpnGateways
func (c *Client) DescribeVpnGatewaysRequest(input *DescribeVpnGatewaysInput) DescribeVpnGatewaysRequest {
	op := &aws.Operation{
		Name:       opDescribeVpnGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVpnGatewaysInput{}
	}

	req := c.newRequest(op, input, &DescribeVpnGatewaysOutput{})
	return DescribeVpnGatewaysRequest{Request: req, Input: input, Copy: c.DescribeVpnGatewaysRequest}
}

// DescribeVpnGatewaysRequest is the request type for the
// DescribeVpnGateways API operation.
type DescribeVpnGatewaysRequest struct {
	*aws.Request
	Input *DescribeVpnGatewaysInput
	Copy  func(*DescribeVpnGatewaysInput) DescribeVpnGatewaysRequest
}

// Send marshals and sends the DescribeVpnGateways API request.
func (r DescribeVpnGatewaysRequest) Send(ctx context.Context) (*DescribeVpnGatewaysResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeVpnGatewaysResponse{
		DescribeVpnGatewaysOutput: r.Request.Data.(*DescribeVpnGatewaysOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeVpnGatewaysResponse is the response type for the
// DescribeVpnGateways API operation.
type DescribeVpnGatewaysResponse struct {
	*DescribeVpnGatewaysOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeVpnGateways request.
func (r *DescribeVpnGatewaysResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
