// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/ec2query"
)

// Contains the parameters for DeleteVpnConnection.
type DeleteVpnConnectionInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the VPN connection.
	//
	// VpnConnectionId is a required field
	VpnConnectionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVpnConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVpnConnectionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteVpnConnectionInput"}

	if s.VpnConnectionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VpnConnectionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteVpnConnectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVpnConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteVpnConnection = "DeleteVpnConnection"

// DeleteVpnConnectionRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Deletes the specified VPN connection.
//
// If you're deleting the VPC and its associated components, we recommend that
// you detach the virtual private gateway from the VPC and delete the VPC before
// deleting the VPN connection. If you believe that the tunnel credentials for
// your VPN connection have been compromised, you can delete the VPN connection
// and create a new one that has new keys, without needing to delete the VPC
// or virtual private gateway. If you create a new VPN connection, you must
// reconfigure the customer gateway using the new configuration information
// returned with the new VPN connection ID.
//
//    // Example sending a request using DeleteVpnConnectionRequest.
//    req := client.DeleteVpnConnectionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnection
func (c *Client) DeleteVpnConnectionRequest(input *DeleteVpnConnectionInput) DeleteVpnConnectionRequest {
	op := &aws.Operation{
		Name:       opDeleteVpnConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpnConnectionInput{}
	}

	req := c.newRequest(op, input, &DeleteVpnConnectionOutput{})
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteVpnConnectionRequest{Request: req, Input: input, Copy: c.DeleteVpnConnectionRequest}
}

// DeleteVpnConnectionRequest is the request type for the
// DeleteVpnConnection API operation.
type DeleteVpnConnectionRequest struct {
	*aws.Request
	Input *DeleteVpnConnectionInput
	Copy  func(*DeleteVpnConnectionInput) DeleteVpnConnectionRequest
}

// Send marshals and sends the DeleteVpnConnection API request.
func (r DeleteVpnConnectionRequest) Send(ctx context.Context) (*DeleteVpnConnectionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteVpnConnectionResponse{
		DeleteVpnConnectionOutput: r.Request.Data.(*DeleteVpnConnectionOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteVpnConnectionResponse is the response type for the
// DeleteVpnConnection API operation.
type DeleteVpnConnectionResponse struct {
	*DeleteVpnConnectionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteVpnConnection request.
func (r *DeleteVpnConnectionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
