// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ebs

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListSnapshotBlocksInput struct {
	_ struct{} `type:"structure"`

	// The number of results to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"100" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `location:"querystring" locationName:"pageToken" type:"string"`

	// The ID of the snapshot from which to get block indexes and block tokens.
	//
	// SnapshotId is a required field
	SnapshotId *string `location:"uri" locationName:"snapshotId" min:"1" type:"string" required:"true"`

	// The block index from which the list should start. The list in the response
	// will start from this block index or the next valid block index in the snapshot.
	StartingBlockIndex *int64 `location:"querystring" locationName:"startingBlockIndex" type:"integer"`
}

// String returns the string representation
func (s ListSnapshotBlocksInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSnapshotBlocksInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListSnapshotBlocksInput"}
	if s.MaxResults != nil && *s.MaxResults < 100 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 100))
	}

	if s.SnapshotId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SnapshotId"))
	}
	if s.SnapshotId != nil && len(*s.SnapshotId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SnapshotId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListSnapshotBlocksInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.SnapshotId != nil {
		v := *s.SnapshotId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "snapshotId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "pageToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartingBlockIndex != nil {
		v := *s.StartingBlockIndex

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "startingBlockIndex", protocol.Int64Value(v), metadata)
	}
	return nil
}

type ListSnapshotBlocksOutput struct {
	_ struct{} `type:"structure"`

	// The size of the block.
	BlockSize *int64 `type:"integer"`

	// An array of objects containing information about the blocks.
	Blocks []Block `type:"list" sensitive:"true"`

	// The time when the block token expires.
	ExpiryTime *time.Time `type:"timestamp"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `type:"string"`

	// The size of the volume in GB.
	VolumeSize *int64 `type:"long"`
}

// String returns the string representation
func (s ListSnapshotBlocksOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListSnapshotBlocksOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.BlockSize != nil {
		v := *s.BlockSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BlockSize", protocol.Int64Value(v), metadata)
	}
	if s.Blocks != nil {
		v := s.Blocks

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Blocks", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ExpiryTime != nil {
		v := *s.ExpiryTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExpiryTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VolumeSize != nil {
		v := *s.VolumeSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VolumeSize", protocol.Int64Value(v), metadata)
	}
	return nil
}

const opListSnapshotBlocks = "ListSnapshotBlocks"

// ListSnapshotBlocksRequest returns a request value for making API operation for
// Amazon Elastic Block Store.
//
// Returns the block indexes and block tokens for blocks in an Amazon Elastic
// Block Store snapshot.
//
//    // Example sending a request using ListSnapshotBlocksRequest.
//    req := client.ListSnapshotBlocksRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ebs-2019-11-02/ListSnapshotBlocks
func (c *Client) ListSnapshotBlocksRequest(input *ListSnapshotBlocksInput) ListSnapshotBlocksRequest {
	op := &aws.Operation{
		Name:       opListSnapshotBlocks,
		HTTPMethod: "GET",
		HTTPPath:   "/snapshots/{snapshotId}/blocks",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSnapshotBlocksInput{}
	}

	req := c.newRequest(op, input, &ListSnapshotBlocksOutput{})
	return ListSnapshotBlocksRequest{Request: req, Input: input, Copy: c.ListSnapshotBlocksRequest}
}

// ListSnapshotBlocksRequest is the request type for the
// ListSnapshotBlocks API operation.
type ListSnapshotBlocksRequest struct {
	*aws.Request
	Input *ListSnapshotBlocksInput
	Copy  func(*ListSnapshotBlocksInput) ListSnapshotBlocksRequest
}

// Send marshals and sends the ListSnapshotBlocks API request.
func (r ListSnapshotBlocksRequest) Send(ctx context.Context) (*ListSnapshotBlocksResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListSnapshotBlocksResponse{
		ListSnapshotBlocksOutput: r.Request.Data.(*ListSnapshotBlocksOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListSnapshotBlocksRequestPaginator returns a paginator for ListSnapshotBlocks.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListSnapshotBlocksRequest(input)
//   p := ebs.NewListSnapshotBlocksRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListSnapshotBlocksPaginator(req ListSnapshotBlocksRequest) ListSnapshotBlocksPaginator {
	return ListSnapshotBlocksPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListSnapshotBlocksInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListSnapshotBlocksPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListSnapshotBlocksPaginator struct {
	aws.Pager
}

func (p *ListSnapshotBlocksPaginator) CurrentPage() *ListSnapshotBlocksOutput {
	return p.Pager.CurrentPage().(*ListSnapshotBlocksOutput)
}

// ListSnapshotBlocksResponse is the response type for the
// ListSnapshotBlocks API operation.
type ListSnapshotBlocksResponse struct {
	*ListSnapshotBlocksOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListSnapshotBlocks request.
func (r *ListSnapshotBlocksResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
