// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ebs

import (
	"context"
	"io"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetSnapshotBlockInput struct {
	_ struct{} `type:"structure"`

	// The block index of the block from which to get data.
	//
	// Obtain the block index by running the list changed blocks or list snapshot
	// blocks operations.
	//
	// BlockIndex is a required field
	BlockIndex *int64 `location:"uri" locationName:"blockIndex" type:"integer" required:"true"`

	// The block token of the block from which to get data.
	//
	// Obtain the block token by running the list changed blocks or list snapshot
	// blocks operations.
	//
	// BlockToken is a required field
	BlockToken *string `location:"querystring" locationName:"blockToken" type:"string" required:"true"`

	// The ID of the snapshot containing the block from which to get data.
	//
	// SnapshotId is a required field
	SnapshotId *string `location:"uri" locationName:"snapshotId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSnapshotBlockInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSnapshotBlockInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetSnapshotBlockInput"}

	if s.BlockIndex == nil {
		invalidParams.Add(aws.NewErrParamRequired("BlockIndex"))
	}

	if s.BlockToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("BlockToken"))
	}

	if s.SnapshotId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SnapshotId"))
	}
	if s.SnapshotId != nil && len(*s.SnapshotId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SnapshotId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetSnapshotBlockInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.BlockIndex != nil {
		v := *s.BlockIndex

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "blockIndex", protocol.Int64Value(v), metadata)
	}
	if s.SnapshotId != nil {
		v := *s.SnapshotId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "snapshotId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BlockToken != nil {
		v := *s.BlockToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "blockToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetSnapshotBlockOutput struct {
	_ struct{} `type:"structure" payload:"BlockData"`

	// The data content of the block.
	BlockData io.ReadCloser `type:"blob" sensitive:"true"`

	// The checksum generated for the block.
	Checksum *string `location:"header" locationName:"x-amz-Checksum" type:"string"`

	// The algorithm used to generate the checksum for the block, such as SHA256.
	ChecksumAlgorithm ChecksumAlgorithm `location:"header" locationName:"x-amz-Checksum-Algorithm" type:"string" enum:"true"`

	// The size of the data in the block.
	DataLength *int64 `location:"header" locationName:"x-amz-Data-Length" type:"integer"`
}

// String returns the string representation
func (s GetSnapshotBlockOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetSnapshotBlockOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Checksum != nil {
		v := *s.Checksum

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-Checksum", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ChecksumAlgorithm) > 0 {
		v := s.ChecksumAlgorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-Checksum-Algorithm", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.DataLength != nil {
		v := *s.DataLength

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-Data-Length", protocol.Int64Value(v), metadata)
	}
	// Skipping BlockData Output type's body not valid.
	return nil
}

const opGetSnapshotBlock = "GetSnapshotBlock"

// GetSnapshotBlockRequest returns a request value for making API operation for
// Amazon Elastic Block Store.
//
// Returns the data in a block in an Amazon Elastic Block Store snapshot.
//
//    // Example sending a request using GetSnapshotBlockRequest.
//    req := client.GetSnapshotBlockRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ebs-2019-11-02/GetSnapshotBlock
func (c *Client) GetSnapshotBlockRequest(input *GetSnapshotBlockInput) GetSnapshotBlockRequest {
	op := &aws.Operation{
		Name:       opGetSnapshotBlock,
		HTTPMethod: "GET",
		HTTPPath:   "/snapshots/{snapshotId}/blocks/{blockIndex}",
	}

	if input == nil {
		input = &GetSnapshotBlockInput{}
	}

	req := c.newRequest(op, input, &GetSnapshotBlockOutput{})
	return GetSnapshotBlockRequest{Request: req, Input: input, Copy: c.GetSnapshotBlockRequest}
}

// GetSnapshotBlockRequest is the request type for the
// GetSnapshotBlock API operation.
type GetSnapshotBlockRequest struct {
	*aws.Request
	Input *GetSnapshotBlockInput
	Copy  func(*GetSnapshotBlockInput) GetSnapshotBlockRequest
}

// Send marshals and sends the GetSnapshotBlock API request.
func (r GetSnapshotBlockRequest) Send(ctx context.Context) (*GetSnapshotBlockResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetSnapshotBlockResponse{
		GetSnapshotBlockOutput: r.Request.Data.(*GetSnapshotBlockOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetSnapshotBlockResponse is the response type for the
// GetSnapshotBlock API operation.
type GetSnapshotBlockResponse struct {
	*GetSnapshotBlockOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetSnapshotBlock request.
func (r *GetSnapshotBlockResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
