// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directconnect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeLocationsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeLocationsInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeLocationsOutput struct {
	_ struct{} `type:"structure"`

	// The locations.
	Locations []Location `locationName:"locations" type:"list"`
}

// String returns the string representation
func (s DescribeLocationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeLocations = "DescribeLocations"

// DescribeLocationsRequest returns a request value for making API operation for
// AWS Direct Connect.
//
// Lists the AWS Direct Connect locations in the current AWS Region. These are
// the locations that can be selected when calling CreateConnection or CreateInterconnect.
//
//    // Example sending a request using DescribeLocationsRequest.
//    req := client.DescribeLocationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLocations
func (c *Client) DescribeLocationsRequest(input *DescribeLocationsInput) DescribeLocationsRequest {
	op := &aws.Operation{
		Name:       opDescribeLocations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLocationsInput{}
	}

	req := c.newRequest(op, input, &DescribeLocationsOutput{})
	return DescribeLocationsRequest{Request: req, Input: input, Copy: c.DescribeLocationsRequest}
}

// DescribeLocationsRequest is the request type for the
// DescribeLocations API operation.
type DescribeLocationsRequest struct {
	*aws.Request
	Input *DescribeLocationsInput
	Copy  func(*DescribeLocationsInput) DescribeLocationsRequest
}

// Send marshals and sends the DescribeLocations API request.
func (r DescribeLocationsRequest) Send(ctx context.Context) (*DescribeLocationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeLocationsResponse{
		DescribeLocationsOutput: r.Request.Data.(*DescribeLocationsOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeLocationsResponse is the response type for the
// DescribeLocations API operation.
type DescribeLocationsResponse struct {
	*DescribeLocationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeLocations request.
func (r *DescribeLocationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
