// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dax

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeParameterGroupsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	//
	// The value for MaxResults must be between 20 and 100.
	MaxResults *int64 `type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `type:"string"`

	// The names of the parameter groups.
	ParameterGroupNames []string `type:"list"`
}

// String returns the string representation
func (s DescribeParameterGroupsInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeParameterGroupsOutput struct {
	_ struct{} `type:"structure"`

	// Provides an identifier to allow retrieval of paginated results.
	NextToken *string `type:"string"`

	// An array of parameter groups. Each element in the array represents one parameter
	// group.
	ParameterGroups []ParameterGroup `type:"list"`
}

// String returns the string representation
func (s DescribeParameterGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeParameterGroups = "DescribeParameterGroups"

// DescribeParameterGroupsRequest returns a request value for making API operation for
// Amazon DynamoDB Accelerator (DAX).
//
// Returns a list of parameter group descriptions. If a parameter group name
// is specified, the list will contain only the descriptions for that group.
//
//    // Example sending a request using DescribeParameterGroupsRequest.
//    req := client.DescribeParameterGroupsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeParameterGroups
func (c *Client) DescribeParameterGroupsRequest(input *DescribeParameterGroupsInput) DescribeParameterGroupsRequest {
	op := &aws.Operation{
		Name:       opDescribeParameterGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeParameterGroupsInput{}
	}

	req := c.newRequest(op, input, &DescribeParameterGroupsOutput{})
	return DescribeParameterGroupsRequest{Request: req, Input: input, Copy: c.DescribeParameterGroupsRequest}
}

// DescribeParameterGroupsRequest is the request type for the
// DescribeParameterGroups API operation.
type DescribeParameterGroupsRequest struct {
	*aws.Request
	Input *DescribeParameterGroupsInput
	Copy  func(*DescribeParameterGroupsInput) DescribeParameterGroupsRequest
}

// Send marshals and sends the DescribeParameterGroups API request.
func (r DescribeParameterGroupsRequest) Send(ctx context.Context) (*DescribeParameterGroupsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeParameterGroupsResponse{
		DescribeParameterGroupsOutput: r.Request.Data.(*DescribeParameterGroupsOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeParameterGroupsResponse is the response type for the
// DescribeParameterGroups API operation.
type DescribeParameterGroupsResponse struct {
	*DescribeParameterGroupsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeParameterGroups request.
func (r *DescribeParameterGroupsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
