// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListAggregateDiscoveredResourcesInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// Filters the results based on the ResourceFilters object.
	Filters *ResourceFilters `type:"structure"`

	// The maximum number of resource identifiers returned on each page. The default
	// is 100. You cannot specify a number greater than 100. If you specify 0, AWS
	// Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The type of resources that you want AWS Config to list in the response.
	//
	// ResourceType is a required field
	ResourceType ResourceType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ListAggregateDiscoveredResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAggregateDiscoveredResourcesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListAggregateDiscoveredResourcesInput"}

	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}
	if len(s.ResourceType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ResourceType"))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListAggregateDiscoveredResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// Returns a list of ResourceIdentifiers objects.
	ResourceIdentifiers []AggregateResourceIdentifier `type:"list"`
}

// String returns the string representation
func (s ListAggregateDiscoveredResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListAggregateDiscoveredResources = "ListAggregateDiscoveredResources"

// ListAggregateDiscoveredResourcesRequest returns a request value for making API operation for
// AWS Config.
//
// Accepts a resource type and returns a list of resource identifiers that are
// aggregated for a specific resource type across accounts and regions. A resource
// identifier includes the resource type, ID, (if available) the custom resource
// name, source account, and source region. You can narrow the results to include
// only resources that have specific resource IDs, or a resource name, or source
// account ID, or source region.
//
// For example, if the input consists of accountID 12345678910 and the region
// is us-east-1 for resource type AWS::EC2::Instance then the API returns all
// the EC2 instance identifiers of accountID 12345678910 and region us-east-1.
//
//    // Example sending a request using ListAggregateDiscoveredResourcesRequest.
//    req := client.ListAggregateDiscoveredResourcesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListAggregateDiscoveredResources
func (c *Client) ListAggregateDiscoveredResourcesRequest(input *ListAggregateDiscoveredResourcesInput) ListAggregateDiscoveredResourcesRequest {
	op := &aws.Operation{
		Name:       opListAggregateDiscoveredResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAggregateDiscoveredResourcesInput{}
	}

	req := c.newRequest(op, input, &ListAggregateDiscoveredResourcesOutput{})
	return ListAggregateDiscoveredResourcesRequest{Request: req, Input: input, Copy: c.ListAggregateDiscoveredResourcesRequest}
}

// ListAggregateDiscoveredResourcesRequest is the request type for the
// ListAggregateDiscoveredResources API operation.
type ListAggregateDiscoveredResourcesRequest struct {
	*aws.Request
	Input *ListAggregateDiscoveredResourcesInput
	Copy  func(*ListAggregateDiscoveredResourcesInput) ListAggregateDiscoveredResourcesRequest
}

// Send marshals and sends the ListAggregateDiscoveredResources API request.
func (r ListAggregateDiscoveredResourcesRequest) Send(ctx context.Context) (*ListAggregateDiscoveredResourcesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListAggregateDiscoveredResourcesResponse{
		ListAggregateDiscoveredResourcesOutput: r.Request.Data.(*ListAggregateDiscoveredResourcesOutput),
		response:                               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListAggregateDiscoveredResourcesResponse is the response type for the
// ListAggregateDiscoveredResources API operation.
type ListAggregateDiscoveredResourcesResponse struct {
	*ListAggregateDiscoveredResourcesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListAggregateDiscoveredResources request.
func (r *ListAggregateDiscoveredResourcesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
