// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeRetentionConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// A list of names of retention configurations for which you want details. If
	// you do not specify a name, AWS Config returns details for all the retention
	// configurations for that account.
	//
	// Currently, AWS Config supports only one retention configuration per region
	// in your account.
	RetentionConfigurationNames []string `type:"list"`
}

// String returns the string representation
func (s DescribeRetentionConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeRetentionConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// Returns a retention configuration object.
	RetentionConfigurations []RetentionConfiguration `type:"list"`
}

// String returns the string representation
func (s DescribeRetentionConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeRetentionConfigurations = "DescribeRetentionConfigurations"

// DescribeRetentionConfigurationsRequest returns a request value for making API operation for
// AWS Config.
//
// Returns the details of one or more retention configurations. If the retention
// configuration name is not specified, this action returns the details for
// all the retention configurations for that account.
//
// Currently, AWS Config supports only one retention configuration per region
// in your account.
//
//    // Example sending a request using DescribeRetentionConfigurationsRequest.
//    req := client.DescribeRetentionConfigurationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRetentionConfigurations
func (c *Client) DescribeRetentionConfigurationsRequest(input *DescribeRetentionConfigurationsInput) DescribeRetentionConfigurationsRequest {
	op := &aws.Operation{
		Name:       opDescribeRetentionConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRetentionConfigurationsInput{}
	}

	req := c.newRequest(op, input, &DescribeRetentionConfigurationsOutput{})
	return DescribeRetentionConfigurationsRequest{Request: req, Input: input, Copy: c.DescribeRetentionConfigurationsRequest}
}

// DescribeRetentionConfigurationsRequest is the request type for the
// DescribeRetentionConfigurations API operation.
type DescribeRetentionConfigurationsRequest struct {
	*aws.Request
	Input *DescribeRetentionConfigurationsInput
	Copy  func(*DescribeRetentionConfigurationsInput) DescribeRetentionConfigurationsRequest
}

// Send marshals and sends the DescribeRetentionConfigurations API request.
func (r DescribeRetentionConfigurationsRequest) Send(ctx context.Context) (*DescribeRetentionConfigurationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeRetentionConfigurationsResponse{
		DescribeRetentionConfigurationsOutput: r.Request.Data.(*DescribeRetentionConfigurationsOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeRetentionConfigurationsResponse is the response type for the
// DescribeRetentionConfigurations API operation.
type DescribeRetentionConfigurationsResponse struct {
	*DescribeRetentionConfigurationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeRetentionConfigurations request.
func (r *DescribeRetentionConfigurationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
