// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeConformancePackStatusInput struct {
	_ struct{} `type:"structure"`

	// Comma-separated list of conformance pack names.
	ConformancePackNames []string `type:"list"`

	// The maximum number of conformance packs status returned on each page.
	Limit *int64 `type:"integer"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeConformancePackStatusInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeConformancePackStatusOutput struct {
	_ struct{} `type:"structure"`

	// A list of ConformancePackStatusDetail objects.
	ConformancePackStatusDetails []ConformancePackStatusDetail `type:"list"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeConformancePackStatusOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeConformancePackStatus = "DescribeConformancePackStatus"

// DescribeConformancePackStatusRequest returns a request value for making API operation for
// AWS Config.
//
// Provides one or more conformance packs deployment status.
//
// If there are no conformance packs then you will see an empty result.
//
//    // Example sending a request using DescribeConformancePackStatusRequest.
//    req := client.DescribeConformancePackStatusRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackStatus
func (c *Client) DescribeConformancePackStatusRequest(input *DescribeConformancePackStatusInput) DescribeConformancePackStatusRequest {
	op := &aws.Operation{
		Name:       opDescribeConformancePackStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConformancePackStatusInput{}
	}

	req := c.newRequest(op, input, &DescribeConformancePackStatusOutput{})
	return DescribeConformancePackStatusRequest{Request: req, Input: input, Copy: c.DescribeConformancePackStatusRequest}
}

// DescribeConformancePackStatusRequest is the request type for the
// DescribeConformancePackStatus API operation.
type DescribeConformancePackStatusRequest struct {
	*aws.Request
	Input *DescribeConformancePackStatusInput
	Copy  func(*DescribeConformancePackStatusInput) DescribeConformancePackStatusRequest
}

// Send marshals and sends the DescribeConformancePackStatus API request.
func (r DescribeConformancePackStatusRequest) Send(ctx context.Context) (*DescribeConformancePackStatusResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeConformancePackStatusResponse{
		DescribeConformancePackStatusOutput: r.Request.Data.(*DescribeConformancePackStatusOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeConformancePackStatusResponse is the response type for the
// DescribeConformancePackStatus API operation.
type DescribeConformancePackStatusResponse struct {
	*DescribeConformancePackStatusOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeConformancePackStatus request.
func (r *DescribeConformancePackStatusResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
