// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehend

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateEndpointInput struct {
	_ struct{} `type:"structure"`

	// An idempotency token provided by the customer. If this token matches a previous
	// endpoint creation request, Amazon Comprehend will not return a ResourceInUseException.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The desired number of inference units to be used by the model using this
	// endpoint. Each inference unit represents of a throughput of 100 characters
	// per second.
	//
	// DesiredInferenceUnits is a required field
	DesiredInferenceUnits *int64 `min:"1" type:"integer" required:"true"`

	// This is the descriptive suffix that becomes part of the EndpointArn used
	// for all subsequent requests to this resource.
	//
	// EndpointName is a required field
	EndpointName *string `type:"string" required:"true"`

	// The Amazon Resource Number (ARN) of the model to which the endpoint will
	// be attached.
	//
	// ModelArn is a required field
	ModelArn *string `type:"string" required:"true"`

	// Tags associated with the endpoint being created. A tag is a key-value pair
	// that adds metadata to the endpoint. For example, a tag with "Sales" as the
	// key might be added to an endpoint to indicate its use by the sales department.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s CreateEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEndpointInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateEndpointInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 1))
	}

	if s.DesiredInferenceUnits == nil {
		invalidParams.Add(aws.NewErrParamRequired("DesiredInferenceUnits"))
	}
	if s.DesiredInferenceUnits != nil && *s.DesiredInferenceUnits < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("DesiredInferenceUnits", 1))
	}

	if s.EndpointName == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndpointName"))
	}

	if s.ModelArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ModelArn"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the endpoint being created.
	EndpointArn *string `type:"string"`
}

// String returns the string representation
func (s CreateEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateEndpoint = "CreateEndpoint"

// CreateEndpointRequest returns a request value for making API operation for
// Amazon Comprehend.
//
// Creates a model-specific endpoint for synchronous inference for a previously
// trained custom model
//
//    // Example sending a request using CreateEndpointRequest.
//    req := client.CreateEndpointRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateEndpoint
func (c *Client) CreateEndpointRequest(input *CreateEndpointInput) CreateEndpointRequest {
	op := &aws.Operation{
		Name:       opCreateEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEndpointInput{}
	}

	req := c.newRequest(op, input, &CreateEndpointOutput{})
	return CreateEndpointRequest{Request: req, Input: input, Copy: c.CreateEndpointRequest}
}

// CreateEndpointRequest is the request type for the
// CreateEndpoint API operation.
type CreateEndpointRequest struct {
	*aws.Request
	Input *CreateEndpointInput
	Copy  func(*CreateEndpointInput) CreateEndpointRequest
}

// Send marshals and sends the CreateEndpoint API request.
func (r CreateEndpointRequest) Send(ctx context.Context) (*CreateEndpointResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateEndpointResponse{
		CreateEndpointOutput: r.Request.Data.(*CreateEndpointOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateEndpointResponse is the response type for the
// CreateEndpoint API operation.
type CreateEndpointResponse struct {
	*CreateEndpointOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateEndpoint request.
func (r *CreateEndpointResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
