// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetIdentityProviderByIdentifierInput struct {
	_ struct{} `type:"structure"`

	// The identity provider ID.
	//
	// IdpIdentifier is a required field
	IdpIdentifier *string `min:"1" type:"string" required:"true"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetIdentityProviderByIdentifierInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIdentityProviderByIdentifierInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetIdentityProviderByIdentifierInput"}

	if s.IdpIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("IdpIdentifier"))
	}
	if s.IdpIdentifier != nil && len(*s.IdpIdentifier) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IdpIdentifier", 1))
	}

	if s.UserPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetIdentityProviderByIdentifierOutput struct {
	_ struct{} `type:"structure"`

	// The identity provider object.
	//
	// IdentityProvider is a required field
	IdentityProvider *IdentityProviderType `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetIdentityProviderByIdentifierOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetIdentityProviderByIdentifier = "GetIdentityProviderByIdentifier"

// GetIdentityProviderByIdentifierRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Gets the specified identity provider.
//
//    // Example sending a request using GetIdentityProviderByIdentifierRequest.
//    req := client.GetIdentityProviderByIdentifierRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetIdentityProviderByIdentifier
func (c *Client) GetIdentityProviderByIdentifierRequest(input *GetIdentityProviderByIdentifierInput) GetIdentityProviderByIdentifierRequest {
	op := &aws.Operation{
		Name:       opGetIdentityProviderByIdentifier,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIdentityProviderByIdentifierInput{}
	}

	req := c.newRequest(op, input, &GetIdentityProviderByIdentifierOutput{})
	return GetIdentityProviderByIdentifierRequest{Request: req, Input: input, Copy: c.GetIdentityProviderByIdentifierRequest}
}

// GetIdentityProviderByIdentifierRequest is the request type for the
// GetIdentityProviderByIdentifier API operation.
type GetIdentityProviderByIdentifierRequest struct {
	*aws.Request
	Input *GetIdentityProviderByIdentifierInput
	Copy  func(*GetIdentityProviderByIdentifierInput) GetIdentityProviderByIdentifierRequest
}

// Send marshals and sends the GetIdentityProviderByIdentifier API request.
func (r GetIdentityProviderByIdentifierRequest) Send(ctx context.Context) (*GetIdentityProviderByIdentifierResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetIdentityProviderByIdentifierResponse{
		GetIdentityProviderByIdentifierOutput: r.Request.Data.(*GetIdentityProviderByIdentifierOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetIdentityProviderByIdentifierResponse is the response type for the
// GetIdentityProviderByIdentifier API operation.
type GetIdentityProviderByIdentifierResponse struct {
	*GetIdentityProviderByIdentifierOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetIdentityProviderByIdentifier request.
func (r *GetIdentityProviderByIdentifierResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
