// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the request to create the user import job.
type CreateUserImportJobInput struct {
	_ struct{} `type:"structure"`

	// The role ARN for the Amazon CloudWatch Logging role for the user import job.
	//
	// CloudWatchLogsRoleArn is a required field
	CloudWatchLogsRoleArn *string `min:"20" type:"string" required:"true"`

	// The job name for the user import job.
	//
	// JobName is a required field
	JobName *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool that the users are being imported into.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateUserImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserImportJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateUserImportJobInput"}

	if s.CloudWatchLogsRoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("CloudWatchLogsRoleArn"))
	}
	if s.CloudWatchLogsRoleArn != nil && len(*s.CloudWatchLogsRoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("CloudWatchLogsRoleArn", 20))
	}

	if s.JobName == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobName"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobName", 1))
	}

	if s.UserPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server to the request to create the user
// import job.
type CreateUserImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The job object that represents the user import job.
	UserImportJob *UserImportJobType `type:"structure"`
}

// String returns the string representation
func (s CreateUserImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateUserImportJob = "CreateUserImportJob"

// CreateUserImportJobRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Creates the user import job.
//
//    // Example sending a request using CreateUserImportJobRequest.
//    req := client.CreateUserImportJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserImportJob
func (c *Client) CreateUserImportJobRequest(input *CreateUserImportJobInput) CreateUserImportJobRequest {
	op := &aws.Operation{
		Name:       opCreateUserImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserImportJobInput{}
	}

	req := c.newRequest(op, input, &CreateUserImportJobOutput{})
	return CreateUserImportJobRequest{Request: req, Input: input, Copy: c.CreateUserImportJobRequest}
}

// CreateUserImportJobRequest is the request type for the
// CreateUserImportJob API operation.
type CreateUserImportJobRequest struct {
	*aws.Request
	Input *CreateUserImportJobInput
	Copy  func(*CreateUserImportJobInput) CreateUserImportJobRequest
}

// Send marshals and sends the CreateUserImportJob API request.
func (r CreateUserImportJobRequest) Send(ctx context.Context) (*CreateUserImportJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateUserImportJobResponse{
		CreateUserImportJobOutput: r.Request.Data.(*CreateUserImportJobOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateUserImportJobResponse is the response type for the
// CreateUserImportJob API operation.
type CreateUserImportJobResponse struct {
	*CreateUserImportJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateUserImportJob request.
func (r *CreateUserImportJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
