// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type AdminSetUserMFAPreferenceInput struct {
	_ struct{} `type:"structure"`

	// The SMS text message MFA settings.
	SMSMfaSettings *SMSMfaSettingsType `type:"structure"`

	// The time-based one-time password software token MFA settings.
	SoftwareTokenMfaSettings *SoftwareTokenMfaSettingsType `type:"structure"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user pool username or alias.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s AdminSetUserMFAPreferenceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminSetUserMFAPreferenceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AdminSetUserMFAPreferenceInput"}

	if s.UserPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserPoolId", 1))
	}

	if s.Username == nil {
		invalidParams.Add(aws.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AdminSetUserMFAPreferenceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminSetUserMFAPreferenceOutput) String() string {
	return awsutil.Prettify(s)
}

const opAdminSetUserMFAPreference = "AdminSetUserMFAPreference"

// AdminSetUserMFAPreferenceRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Sets the user's multi-factor authentication (MFA) preference, including which
// MFA options are enabled and if any are preferred. Only one factor can be
// set as preferred. The preferred MFA factor will be used to authenticate a
// user if multiple factors are enabled. If multiple options are enabled and
// no preference is set, a challenge to choose an MFA option will be returned
// during sign in.
//
//    // Example sending a request using AdminSetUserMFAPreferenceRequest.
//    req := client.AdminSetUserMFAPreferenceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserMFAPreference
func (c *Client) AdminSetUserMFAPreferenceRequest(input *AdminSetUserMFAPreferenceInput) AdminSetUserMFAPreferenceRequest {
	op := &aws.Operation{
		Name:       opAdminSetUserMFAPreference,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminSetUserMFAPreferenceInput{}
	}

	req := c.newRequest(op, input, &AdminSetUserMFAPreferenceOutput{})
	return AdminSetUserMFAPreferenceRequest{Request: req, Input: input, Copy: c.AdminSetUserMFAPreferenceRequest}
}

// AdminSetUserMFAPreferenceRequest is the request type for the
// AdminSetUserMFAPreference API operation.
type AdminSetUserMFAPreferenceRequest struct {
	*aws.Request
	Input *AdminSetUserMFAPreferenceInput
	Copy  func(*AdminSetUserMFAPreferenceInput) AdminSetUserMFAPreferenceRequest
}

// Send marshals and sends the AdminSetUserMFAPreference API request.
func (r AdminSetUserMFAPreferenceRequest) Send(ctx context.Context) (*AdminSetUserMFAPreferenceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AdminSetUserMFAPreferenceResponse{
		AdminSetUserMFAPreferenceOutput: r.Request.Data.(*AdminSetUserMFAPreferenceOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AdminSetUserMFAPreferenceResponse is the response type for the
// AdminSetUserMFAPreference API operation.
type AdminSetUserMFAPreferenceResponse struct {
	*AdminSetUserMFAPreferenceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AdminSetUserMFAPreference request.
func (r *AdminSetUserMFAPreferenceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
