// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codepipeline

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListActionExecutionsInput struct {
	_ struct{} `type:"structure"`

	// Input information used to filter action execution history.
	Filter *ActionExecutionFilter `locationName:"filter" type:"structure"`

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value. Action
	// execution history is retained for up to 12 months, based on action execution
	// start times. Default value is 100.
	//
	// Detailed execution history is available for executions run on or after February
	// 21, 2019.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token that was returned from the previous ListActionExecutions call,
	// which can be used to return the next set of action executions in the list.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The name of the pipeline for which you want to list action execution history.
	//
	// PipelineName is a required field
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListActionExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListActionExecutionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListActionExecutionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if s.PipelineName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PipelineName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListActionExecutionsOutput struct {
	_ struct{} `type:"structure"`

	// The details for a list of recent executions, such as action execution ID.
	ActionExecutionDetails []ActionExecutionDetail `locationName:"actionExecutionDetails" type:"list"`

	// If the amount of returned information is significantly large, an identifier
	// is also returned and can be used in a subsequent ListActionExecutions call
	// to return the next set of action executions in the list.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListActionExecutionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListActionExecutions = "ListActionExecutions"

// ListActionExecutionsRequest returns a request value for making API operation for
// AWS CodePipeline.
//
// Lists the action executions that have occurred in a pipeline.
//
//    // Example sending a request using ListActionExecutionsRequest.
//    req := client.ListActionExecutionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListActionExecutions
func (c *Client) ListActionExecutionsRequest(input *ListActionExecutionsInput) ListActionExecutionsRequest {
	op := &aws.Operation{
		Name:       opListActionExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListActionExecutionsInput{}
	}

	req := c.newRequest(op, input, &ListActionExecutionsOutput{})
	return ListActionExecutionsRequest{Request: req, Input: input, Copy: c.ListActionExecutionsRequest}
}

// ListActionExecutionsRequest is the request type for the
// ListActionExecutions API operation.
type ListActionExecutionsRequest struct {
	*aws.Request
	Input *ListActionExecutionsInput
	Copy  func(*ListActionExecutionsInput) ListActionExecutionsRequest
}

// Send marshals and sends the ListActionExecutions API request.
func (r ListActionExecutionsRequest) Send(ctx context.Context) (*ListActionExecutionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListActionExecutionsResponse{
		ListActionExecutionsOutput: r.Request.Data.(*ListActionExecutionsOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListActionExecutionsRequestPaginator returns a paginator for ListActionExecutions.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListActionExecutionsRequest(input)
//   p := codepipeline.NewListActionExecutionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListActionExecutionsPaginator(req ListActionExecutionsRequest) ListActionExecutionsPaginator {
	return ListActionExecutionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListActionExecutionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListActionExecutionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListActionExecutionsPaginator struct {
	aws.Pager
}

func (p *ListActionExecutionsPaginator) CurrentPage() *ListActionExecutionsOutput {
	return p.Pager.CurrentPage().(*ListActionExecutionsOutput)
}

// ListActionExecutionsResponse is the response type for the
// ListActionExecutions API operation.
type ListActionExecutionsResponse struct {
	*ListActionExecutionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListActionExecutions request.
func (r *ListActionExecutionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
