// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codecommit

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type MergeBranchesByFastForwardInput struct {
	_ struct{} `type:"structure"`

	// The branch, tag, HEAD, or other fully qualified reference used to identify
	// a commit (for example, a branch name or a full commit ID).
	//
	// DestinationCommitSpecifier is a required field
	DestinationCommitSpecifier *string `locationName:"destinationCommitSpecifier" type:"string" required:"true"`

	// The name of the repository where you want to merge two branches.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`

	// The branch, tag, HEAD, or other fully qualified reference used to identify
	// a commit (for example, a branch name or a full commit ID).
	//
	// SourceCommitSpecifier is a required field
	SourceCommitSpecifier *string `locationName:"sourceCommitSpecifier" type:"string" required:"true"`

	// The branch where the merge is applied.
	TargetBranch *string `locationName:"targetBranch" min:"1" type:"string"`
}

// String returns the string representation
func (s MergeBranchesByFastForwardInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MergeBranchesByFastForwardInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MergeBranchesByFastForwardInput"}

	if s.DestinationCommitSpecifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("DestinationCommitSpecifier"))
	}

	if s.RepositoryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RepositoryName", 1))
	}

	if s.SourceCommitSpecifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceCommitSpecifier"))
	}
	if s.TargetBranch != nil && len(*s.TargetBranch) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TargetBranch", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type MergeBranchesByFastForwardOutput struct {
	_ struct{} `type:"structure"`

	// The commit ID of the merge in the destination or target branch.
	CommitId *string `locationName:"commitId" type:"string"`

	// The tree ID of the merge in the destination or target branch.
	TreeId *string `locationName:"treeId" type:"string"`
}

// String returns the string representation
func (s MergeBranchesByFastForwardOutput) String() string {
	return awsutil.Prettify(s)
}

const opMergeBranchesByFastForward = "MergeBranchesByFastForward"

// MergeBranchesByFastForwardRequest returns a request value for making API operation for
// AWS CodeCommit.
//
// Merges two branches using the fast-forward merge strategy.
//
//    // Example sending a request using MergeBranchesByFastForwardRequest.
//    req := client.MergeBranchesByFastForwardRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/MergeBranchesByFastForward
func (c *Client) MergeBranchesByFastForwardRequest(input *MergeBranchesByFastForwardInput) MergeBranchesByFastForwardRequest {
	op := &aws.Operation{
		Name:       opMergeBranchesByFastForward,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &MergeBranchesByFastForwardInput{}
	}

	req := c.newRequest(op, input, &MergeBranchesByFastForwardOutput{})
	return MergeBranchesByFastForwardRequest{Request: req, Input: input, Copy: c.MergeBranchesByFastForwardRequest}
}

// MergeBranchesByFastForwardRequest is the request type for the
// MergeBranchesByFastForward API operation.
type MergeBranchesByFastForwardRequest struct {
	*aws.Request
	Input *MergeBranchesByFastForwardInput
	Copy  func(*MergeBranchesByFastForwardInput) MergeBranchesByFastForwardRequest
}

// Send marshals and sends the MergeBranchesByFastForward API request.
func (r MergeBranchesByFastForwardRequest) Send(ctx context.Context) (*MergeBranchesByFastForwardResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &MergeBranchesByFastForwardResponse{
		MergeBranchesByFastForwardOutput: r.Request.Data.(*MergeBranchesByFastForwardOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// MergeBranchesByFastForwardResponse is the response type for the
// MergeBranchesByFastForward API operation.
type MergeBranchesByFastForwardResponse struct {
	*MergeBranchesByFastForwardOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// MergeBranchesByFastForward request.
func (r *MergeBranchesByFastForwardResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
