// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatchlogs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type PutRetentionPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the log group.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`

	// The number of days to retain the log events in the specified log group. Possible
	// values are: 1, 3, 5, 7, 14, 30, 60, 90, 120, 150, 180, 365, 400, 545, 731,
	// 1827, and 3653.
	//
	// RetentionInDays is a required field
	RetentionInDays *int64 `locationName:"retentionInDays" type:"integer" required:"true"`
}

// String returns the string representation
func (s PutRetentionPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRetentionPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutRetentionPolicyInput"}

	if s.LogGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}

	if s.RetentionInDays == nil {
		invalidParams.Add(aws.NewErrParamRequired("RetentionInDays"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutRetentionPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutRetentionPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutRetentionPolicy = "PutRetentionPolicy"

// PutRetentionPolicyRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Sets the retention of the specified log group. A retention policy allows
// you to configure the number of days for which to retain log events in the
// specified log group.
//
//    // Example sending a request using PutRetentionPolicyRequest.
//    req := client.PutRetentionPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutRetentionPolicy
func (c *Client) PutRetentionPolicyRequest(input *PutRetentionPolicyInput) PutRetentionPolicyRequest {
	op := &aws.Operation{
		Name:       opPutRetentionPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRetentionPolicyInput{}
	}

	req := c.newRequest(op, input, &PutRetentionPolicyOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return PutRetentionPolicyRequest{Request: req, Input: input, Copy: c.PutRetentionPolicyRequest}
}

// PutRetentionPolicyRequest is the request type for the
// PutRetentionPolicy API operation.
type PutRetentionPolicyRequest struct {
	*aws.Request
	Input *PutRetentionPolicyInput
	Copy  func(*PutRetentionPolicyInput) PutRetentionPolicyRequest
}

// Send marshals and sends the PutRetentionPolicy API request.
func (r PutRetentionPolicyRequest) Send(ctx context.Context) (*PutRetentionPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutRetentionPolicyResponse{
		PutRetentionPolicyOutput: r.Request.Data.(*PutRetentionPolicyOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutRetentionPolicyResponse is the response type for the
// PutRetentionPolicy API operation.
type PutRetentionPolicyResponse struct {
	*PutRetentionPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutRetentionPolicy request.
func (r *PutRetentionPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
