// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatchlogs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeQueriesInput struct {
	_ struct{} `type:"structure"`

	// Limits the returned queries to only those for the specified log group.
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string"`

	// Limits the number of returned queries to the specified number.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of items to return. The token expires after 24
	// hours.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Limits the returned queries to only those that have the specified status.
	// Valid values are Cancelled, Complete, Failed, Running, and Scheduled.
	Status QueryStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s DescribeQueriesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeQueriesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeQueriesInput"}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeQueriesOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of items to return. The token expires after 24
	// hours.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The list of queries that match the request.
	Queries []QueryInfo `locationName:"queries" type:"list"`
}

// String returns the string representation
func (s DescribeQueriesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeQueries = "DescribeQueries"

// DescribeQueriesRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Returns a list of CloudWatch Logs Insights queries that are scheduled, executing,
// or have been executed recently in this account. You can request all queries,
// or limit it to queries of a specific log group or queries with a certain
// status.
//
//    // Example sending a request using DescribeQueriesRequest.
//    req := client.DescribeQueriesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeQueries
func (c *Client) DescribeQueriesRequest(input *DescribeQueriesInput) DescribeQueriesRequest {
	op := &aws.Operation{
		Name:       opDescribeQueries,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeQueriesInput{}
	}

	req := c.newRequest(op, input, &DescribeQueriesOutput{})
	return DescribeQueriesRequest{Request: req, Input: input, Copy: c.DescribeQueriesRequest}
}

// DescribeQueriesRequest is the request type for the
// DescribeQueries API operation.
type DescribeQueriesRequest struct {
	*aws.Request
	Input *DescribeQueriesInput
	Copy  func(*DescribeQueriesInput) DescribeQueriesRequest
}

// Send marshals and sends the DescribeQueries API request.
func (r DescribeQueriesRequest) Send(ctx context.Context) (*DescribeQueriesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeQueriesResponse{
		DescribeQueriesOutput: r.Request.Data.(*DescribeQueriesOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeQueriesResponse is the response type for the
// DescribeQueries API operation.
type DescribeQueriesResponse struct {
	*DescribeQueriesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeQueries request.
func (r *DescribeQueriesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
