// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudfront

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The request to get a distribution configuration.
type GetDistributionConfigInput struct {
	_ struct{} `type:"structure"`

	// The distribution's ID. If the ID is empty, an empty distribution configuration
	// is returned.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDistributionConfigInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDistributionConfigInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetDistributionConfigInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetDistributionConfigInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.StringValue(v), metadata)
	}
	return nil
}

// The returned result of the corresponding request.
type GetDistributionConfigOutput struct {
	_ struct{} `type:"structure" payload:"DistributionConfig"`

	// The distribution's configuration information.
	DistributionConfig *DistributionConfig `type:"structure"`

	// The current version of the configuration. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`
}

// String returns the string representation
func (s GetDistributionConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetDistributionConfigOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.DistributionConfig != nil {
		v := s.DistributionConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "DistributionConfig", v, metadata)
	}
	return nil
}

const opGetDistributionConfig = "GetDistributionConfig2019_03_26"

// GetDistributionConfigRequest returns a request value for making API operation for
// Amazon CloudFront.
//
// Get the configuration information about a distribution.
//
//    // Example sending a request using GetDistributionConfigRequest.
//    req := client.GetDistributionConfigRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetDistributionConfig
func (c *Client) GetDistributionConfigRequest(input *GetDistributionConfigInput) GetDistributionConfigRequest {
	op := &aws.Operation{
		Name:       opGetDistributionConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-03-26/distribution/{Id}/config",
	}

	if input == nil {
		input = &GetDistributionConfigInput{}
	}

	req := c.newRequest(op, input, &GetDistributionConfigOutput{})
	return GetDistributionConfigRequest{Request: req, Input: input, Copy: c.GetDistributionConfigRequest}
}

// GetDistributionConfigRequest is the request type for the
// GetDistributionConfig API operation.
type GetDistributionConfigRequest struct {
	*aws.Request
	Input *GetDistributionConfigInput
	Copy  func(*GetDistributionConfigInput) GetDistributionConfigRequest
}

// Send marshals and sends the GetDistributionConfig API request.
func (r GetDistributionConfigRequest) Send(ctx context.Context) (*GetDistributionConfigResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetDistributionConfigResponse{
		GetDistributionConfigOutput: r.Request.Data.(*GetDistributionConfigOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetDistributionConfigResponse is the response type for the
// GetDistributionConfig API operation.
type GetDistributionConfigResponse struct {
	*GetDistributionConfigOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetDistributionConfig request.
func (r *GetDistributionConfigResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
