// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appsync

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Represents the input of a DeleteApiCache operation.
type DeleteApiCacheInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApiCacheInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApiCacheInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteApiCacheInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteApiCacheInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents the output of a DeleteApiCache operation.
type DeleteApiCacheOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteApiCacheOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteApiCacheOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteApiCache = "DeleteApiCache"

// DeleteApiCacheRequest returns a request value for making API operation for
// AWS AppSync.
//
// Deletes an ApiCache object.
//
//    // Example sending a request using DeleteApiCacheRequest.
//    req := client.DeleteApiCacheRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteApiCache
func (c *Client) DeleteApiCacheRequest(input *DeleteApiCacheInput) DeleteApiCacheRequest {
	op := &aws.Operation{
		Name:       opDeleteApiCache,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apis/{apiId}/ApiCaches",
	}

	if input == nil {
		input = &DeleteApiCacheInput{}
	}

	req := c.newRequest(op, input, &DeleteApiCacheOutput{})
	return DeleteApiCacheRequest{Request: req, Input: input, Copy: c.DeleteApiCacheRequest}
}

// DeleteApiCacheRequest is the request type for the
// DeleteApiCache API operation.
type DeleteApiCacheRequest struct {
	*aws.Request
	Input *DeleteApiCacheInput
	Copy  func(*DeleteApiCacheInput) DeleteApiCacheRequest
}

// Send marshals and sends the DeleteApiCache API request.
func (r DeleteApiCacheRequest) Send(ctx context.Context) (*DeleteApiCacheResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteApiCacheResponse{
		DeleteApiCacheOutput: r.Request.Data.(*DeleteApiCacheOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteApiCacheResponse is the response type for the
// DeleteApiCache API operation.
type DeleteApiCacheResponse struct {
	*DeleteApiCacheOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteApiCache request.
func (r *DeleteApiCacheResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
