// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package applicationinsightsiface provides an interface to enable mocking the Amazon CloudWatch Application Insights service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package applicationinsightsiface

import (
	"github.com/aws/aws-sdk-go-v2/service/applicationinsights"
)

// ClientAPI provides an interface to enable mocking the
// applicationinsights.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Application Insights.
//    func myFunc(svc applicationinsightsiface.ClientAPI) bool {
//        // Make svc.CreateApplication request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := applicationinsights.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        applicationinsightsiface.ClientPI
//    }
//    func (m *mockClientClient) CreateApplication(input *applicationinsights.CreateApplicationInput) (*applicationinsights.CreateApplicationOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateApplicationRequest(*applicationinsights.CreateApplicationInput) applicationinsights.CreateApplicationRequest

	CreateComponentRequest(*applicationinsights.CreateComponentInput) applicationinsights.CreateComponentRequest

	CreateLogPatternRequest(*applicationinsights.CreateLogPatternInput) applicationinsights.CreateLogPatternRequest

	DeleteApplicationRequest(*applicationinsights.DeleteApplicationInput) applicationinsights.DeleteApplicationRequest

	DeleteComponentRequest(*applicationinsights.DeleteComponentInput) applicationinsights.DeleteComponentRequest

	DeleteLogPatternRequest(*applicationinsights.DeleteLogPatternInput) applicationinsights.DeleteLogPatternRequest

	DescribeApplicationRequest(*applicationinsights.DescribeApplicationInput) applicationinsights.DescribeApplicationRequest

	DescribeComponentRequest(*applicationinsights.DescribeComponentInput) applicationinsights.DescribeComponentRequest

	DescribeComponentConfigurationRequest(*applicationinsights.DescribeComponentConfigurationInput) applicationinsights.DescribeComponentConfigurationRequest

	DescribeComponentConfigurationRecommendationRequest(*applicationinsights.DescribeComponentConfigurationRecommendationInput) applicationinsights.DescribeComponentConfigurationRecommendationRequest

	DescribeLogPatternRequest(*applicationinsights.DescribeLogPatternInput) applicationinsights.DescribeLogPatternRequest

	DescribeObservationRequest(*applicationinsights.DescribeObservationInput) applicationinsights.DescribeObservationRequest

	DescribeProblemRequest(*applicationinsights.DescribeProblemInput) applicationinsights.DescribeProblemRequest

	DescribeProblemObservationsRequest(*applicationinsights.DescribeProblemObservationsInput) applicationinsights.DescribeProblemObservationsRequest

	ListApplicationsRequest(*applicationinsights.ListApplicationsInput) applicationinsights.ListApplicationsRequest

	ListComponentsRequest(*applicationinsights.ListComponentsInput) applicationinsights.ListComponentsRequest

	ListLogPatternSetsRequest(*applicationinsights.ListLogPatternSetsInput) applicationinsights.ListLogPatternSetsRequest

	ListLogPatternsRequest(*applicationinsights.ListLogPatternsInput) applicationinsights.ListLogPatternsRequest

	ListProblemsRequest(*applicationinsights.ListProblemsInput) applicationinsights.ListProblemsRequest

	ListTagsForResourceRequest(*applicationinsights.ListTagsForResourceInput) applicationinsights.ListTagsForResourceRequest

	TagResourceRequest(*applicationinsights.TagResourceInput) applicationinsights.TagResourceRequest

	UntagResourceRequest(*applicationinsights.UntagResourceInput) applicationinsights.UntagResourceRequest

	UpdateApplicationRequest(*applicationinsights.UpdateApplicationInput) applicationinsights.UpdateApplicationRequest

	UpdateComponentRequest(*applicationinsights.UpdateComponentInput) applicationinsights.UpdateComponentRequest

	UpdateComponentConfigurationRequest(*applicationinsights.UpdateComponentConfigurationInput) applicationinsights.UpdateComponentConfigurationRequest

	UpdateLogPatternRequest(*applicationinsights.UpdateLogPatternInput) applicationinsights.UpdateLogPatternRequest
}

var _ ClientAPI = (*applicationinsights.Client)(nil)
